## test of gelfand.m

##
## Copyright (C) 2005 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: gelfandt.m,v 1.1 2008/09/05 14:55:41 ecm Exp $

clear

N=32;

printf("test1: test of the symmetries T_{m,n}(phi,theta,0)= (-1)^(n) conjugate( T_{m,-n}(phi+pi,pi-theta,0) )\n");

phi=2*pi*rand(N);
theta=pi*rand(N);
psi=zeros(N);

error_flag=0;
for m=-2:-2,
  for n=-2:+2,
    p1=gelfand(m,n,phi,theta,psi);
    p2=conj((-1)^(m+n)*gelfand(m,-n,phi+pi,pi-theta,psi));
    if (any(vec(abs(p1-p2))>sqrt(eps)))
      error_flag=1;
    end;
  end;
end;

if (error_flag==1)
  error("test1 failed\n");
else
  printf("test1 passed\n");
end;

printf("test2: test of the symmetries T_{m,n}(phi,theta,phi)=T_{n,m}(phi,theta,phi)\n");

phi=2*pi*rand(N);
theta=pi*rand(N);

error_flag=0;
for m=-2:-2,
  for n=-2:+2,
    p1=gelfand(m,n,phi,theta,phi);
    p2=gelfand(n,m,phi,theta,phi);
    if (any(vec(abs(p1-p2))>sqrt(eps)))
      error_flag=1;
    end;
  end;
end;

if (error_flag==1)
  error("test2 failed\n");
else
  printf("test2 passed\n");
end;

printf("test3: test of the symmetries T_{m,n}(phi,theta,psi)= (-1)^(m+n) conjugate( T_{-m,-n}(phi,theta,psi) )\n");

phi=2*pi*rand(N);
theta=pi*rand(N);
psi=2*pi*rand(N);

error_flag=0;
for m=-2:-2,
  for n=-2:+2,
    p1=gelfand(m,n,phi,theta,phi);
    p2=(-1)^(m+n)*conj(gelfand(-m,-n,phi,theta,phi));
    if (any(vec(abs(p1-p2))>sqrt(eps)))
      m,n
      error_flag=1;
    end;
  end;
end;

if (error_flag==1)
  error("test3 failed\n");
else
  printf("test3 passed\n");
end;

# printf("test3: test of the addition theorem\n");
## regarder la note "generalized spherical harmonics"
## cahier ??, relation explicite pour les angles...

# N=4;

# theta1=randn(N);
# phi1=randn(N);
# psi1=randn(N);

# theta2=randn(N);
# phi2=randn(N);
# psi2=randn(N);

# theta=theta1+theta2;
# phi=phi1+phi2;
# psi=psi1+psi2;

# for m=-2:+2,
#   for n=-2:+2,
#     f1=gelfand(m,n,theta,phi,psi);    
#     f2=zeros(size(f1));
#     for s=-2:+2,
#       f2=gelfand(m,s,theta1,phi1,psi1).*gelfand(s,n,theta2,phi2,psi2);
#     end;
#   end;
# end;

# if (any(any(abs(f1-f2)>=eps)))
#   error("test3 failed\n");
# else
#   printf("test3 passed\n");
# end;

 printf("test4: test of the unitarity\n");

 N=4;

 theta=randn(N);
 phi=randn(N);
 psi=randn(N);

 flag=0;
 for m=-2:+2,
   res=zeros(N);
   for n=-2:+2,
     f=gelfand(m,n,theta,phi,psi);    
     res+=abs(f).^2;
   end;

   if (any(any(abs(res-1.0)>=sqrt(eps))))
     flag=1;
     break;
   end;

 end;
 
 if (flag==1)
   error("test4 failed\n");
 else
   printf("test4 passed\n");
 end;

