##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

function r=wgs84(long,lat)
#WGS84  Radius of Earth WGS-84 ellipsoid
#          R=WGS84(LAT,LONG) computes the distance from Earth geoid center as
#          given by WSG84 reference ellipsoid
#          LONG            :  (geocentric) longitude (radian)
#          LAT             :  (geocentric) latitude (radian)
#          R               :  radius from Earth geoid center (meter)

# $Id: wgs84.m,v 1.5 2008/09/15 14:49:27 ecm Exp $

if (nargin<2)
  error("Usage: d=wgs84(lat,long)");
end;

if !exist("__AWGS84_SI__","var")
  constants;
endif;
global __AWGS84_SI__;
A=__AWGS84_SI__;

if !exist("__BWGS84_SI__","var")
  constants;
endif;
global __BWGS84_SI__;
B=__BWGS84_SI__;

r=sqrt((A*cos(lat))^2+(B*sin(lat))^2); ## earth geoid

endfunction;

