function b=weyl(a,fs)

## -*- texinfo -*-
## @deftypefn {Function File}  {@var{out} =} weyl(@var{in},@var{fs})
## @deftypefnx {Function File} {@var{out} =} weyl(@var{in})
## Compute the Weyl symbol of @var{in}. The sampling frequency
## can be specified. It is otherwise assumed to be @var{fs} = 1
## @end deftypefn

## Copyright (C) 2008 Eric Chassande-Mottin, CNRS (France)

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see .

if nargchk(1,2,nargin)
  usage("out = weyl( in [, fs] )");
end;

b=weyl_remap(a);
b=fft(b);

if (nargin == 2),
  b=b/fs;
end;

%!test
%! N=32;
%! a=randn(N);
%! x=randn(N,1);
%! y=randn(N,1);
%! r1=y'*a*x;
%! w=dwv([x,y]);
%! b=weyl(a);
%! r2=real(sum(sum(w.*b))/(2*N));
%! assert(r2,r1,10^(-13));