## Position and orientation information for a collection of GW detectors

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: usual_detectors.m,v 1.8 2008/09/15 14:48:32 ecm Exp $

## convert angle in (degree, minute, second) to radian
## sign is +1 or -1. it associates the direction measurement 
## (Eastward=+1 or Westward=-1) to a sign convention for the output angle.
dms_to_rad=inline("sign*pi*(d+m/60.+s/3600.)/180.0","d","m","s","sign");

## convert angle in decimal degree to radian
deg_to_rad=inline("pi*d/180.0","d");

## Earth center, reference frame
prefix='E';
name='Earth center';
type='ITF';
latitude  = dms_to_rad(0.0,0.0,0.0,0);
longitude = dms_to_rad(0.0,0.0,0.0,0);
x_arm_azimut_from_N = dms_to_rad(0.0,0.0,0.0,1);
y_arm_azimut_from_N = dms_to_rad(0.0,0.0,0.0,1);
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 0.0;
global E;
E=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);
E.radius=0.0;

## GEO600 (ref: lal/packages/tools/include/LALDetectors.h, Revision: 1.8, Mon Aug 13 15:16:59 2007 UTC)
prefix='G1';
name='GEO';
type='ITF';
latitude  = 0.91184982752; ## LAL_GEO_600_DETECTOR_LATITUDE_RAD
longitude = 0.17116780435; ## LAL_GEO_600_DETECTOR_LONGITUDE_RAD
x_arm_azimut_from_N = 2*pi-1.19360100484; ## TWO PI - LAL_GEO_600_DETECTOR_ARM_X_AZIMUTH_RAD
y_arm_azimut_from_N = 2*pi-5.83039279401; ## TWO PI - LAL_GEO_600_DETECTOR_ARM_Y_AZIMUTH_RAD
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 114.425; ## LAL_GEO_600_DETECTOR_ELEVATION_SI
G1=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## Virgo (ref: EGO-REP-INF-111 Issue 1 18/10/2005)
prefix='V1';
name='Virgo';
type='ITF';
latitude  = dms_to_rad(43,37,53.0880,1);
longitude = dms_to_rad(10,30,16.1885,1);
x_arm_azimut_from_N = dms_to_rad(340,34,2.035,1);
y_arm_azimut_from_N = dms_to_rad( 70,34,2.035,1);
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 53.238;
V1=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## LIGO LLO (ref: T980044-10, page 24, table 18)
## (ref: lal/packages/tools/include/LALDetectors.h, Revision: 1.8, Mon Aug 13 15:16:59 2007 UTC)
prefix='L1';
name='LIGO Livingstone';
type='ITF';
latitude  = 0.53342313506; ## LAL_LLO_4K_DETECTOR_LATITUDE_RAD
longitude = -1.58430937078; ## LAL_LLO_4K_DETECTOR_LONGITUDE_RAD
x_arm_azimut_from_N = 2*pi-4.40317772346; ## TWO PI - LAL_LLO_4K_DETECTOR_ARM_X_AZIMUTH_RAD
y_arm_azimut_from_N = 2*pi-2.83238139666; ## TWO PI - LAL_LLO_4K_DETECTOR_ARM_Y_AZIMUTH_RAD
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = -6.574; ## LAL_LLO_4K_DETECTOR_ELEVATION_SI
L1=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## LIGO LHO (ref: T980044-10, page 10, table 4)
## (ref: lal/packages/tools/include/LALDetectors.h, Revision: 1.8, Mon Aug 13 15:16:59 2007 UTC)
prefix1='H1';
name1='LIGO Hanford 4km';
prefix2='H2';
name2='LIGO Hanford 2km';
type='ITF';
latitude = 0.81079526383; ## LAL_LHO_4K_DETECTOR_LATITUDE_RAD
longitude = -2.08405676917; ## LAL_LHO_4K_DETECTOR_LONGITUDE_RAD
x_arm_azimut_from_N = 2*pi-5.65487724844; ## TWO PI - LAL_LHO_4K_DETECTOR_ARM_X_AZIMUTH_RAD
y_arm_azimut_from_N = 2*pi-4.08408092164; ## TWO PI - LAL_LHO_4K_DETECTOR_ARM_Y_AZIMUTH_RAD
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 142.554; ## TWO PI - LAL_LHO_4K_DETECTOR_ELEVATION_SI
H1=create_detector(prefix1,type,name1,longitude,latitude,orientation,elevation);
H2=create_detector(prefix2,type,name2,longitude,latitude,orientation,elevation);

## TAMA (ref: lal/packages/tools/include/LALDetectors.h, Revision: 1.8, Mon Aug 13 15:16:59 2007 UTC)
prefix='T1';
name='TAMA';
type='ITF';
latitude  = 0.62267336022; ## LAL_TAMA_300_DETECTOR_LATITUDE_RAD
longitude = 2.43536359469; ## LAL_TAMA_300_DETECTOR_LONGITUDE_RAD
x_arm_azimut_from_N = 2*pi-4.71238898038469; ## TWO PI - LAL_TAMA_300_DETECTOR_ARM_X_AZIMUTH_RAD
y_arm_azimut_from_N = 2*pi-3.14159265358979; ## TWO PI - LAL_TAMA_300_DETECTOR_ARM_Y_AZIMUTH_RAD 
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 90; ## LAL_TAMA_300_DETECTOR_ELEVATION_SI
T1=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## dummy 1: equatorial, greenwich
prefix='D1';
name='dummy 1';
type='ITF';
latitude  = dms_to_rad(0,0,0,1);
longitude = dms_to_rad(0,0,0,1);
x_arm_azimut_from_N = deg_to_rad(270);
y_arm_azimut_from_N = deg_to_rad(0);
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 0;
D1=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## dummy 2: equatorial plane, opposite greenwich
prefix='D2';
name='dummy 2';
type='ITF';
latitude  = dms_to_rad(0,0,0,1);
longitude = dms_to_rad(180,0,0,1);
x_arm_azimut_from_N = deg_to_rad(0);
y_arm_azimut_from_N = deg_to_rad(90);
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 0;
D2=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## dummy 3: equatorial plane, orthogonal to 1-2
prefix='D3';
name='dummy 3';
type='ITF';
latitude  = dms_to_rad(0,0,0,1);
longitude = dms_to_rad(90,0,0,1);
x_arm_azimut_from_N = deg_to_rad(45);
y_arm_azimut_from_N = deg_to_rad(135);
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 0;
D3=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

## dummy 4: north pole
prefix='D4';
name='dummy 4';
type='ITF';
latitude  = dms_to_rad(90,0,0,1);
longitude = dms_to_rad(0,0,0,1);
x_arm_azimut_from_N = deg_to_rad(0);
y_arm_azimut_from_N = deg_to_rad(90);
orientation=[x_arm_azimut_from_N, y_arm_azimut_from_N];
elevation = 0;
D4=create_detector(prefix,type,name,longitude,latitude,orientation,elevation);

