##PROJ_DIST Projected distance between detectors
##          D=PROJ_DIST(NET,PHI,THETA) computes the distance between 
##          the first detector and the others detectors of 
##          a network, projected along incident direction
##          NET             :  network descriptor
##          PHI             :  direction grid, azimut angle from x-axis
##          THETA           :  direction grid, polar angle from zenith
##          D               :  projected distance
##

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the
## GNU General Public License (GPL), version 2, or at your
## option any later version.
##

## $Id: proj_dist.m,v 1.2 2008/09/03 14:00:52 ecm Exp $

function pd=proj_dist(net,phi,theta)
  
  if (nargin<3)
    error("Usage: d=proj_dist(detector,phi,theta)");
  end;

  if (size(phi)~=size(theta)),
    error("phi and theta must have same size");
  end;
  
  d=length(net);

  if (d>1)

    pd=zeros([size(phi) d-1]);

    ref=  geo_to_cart(net(1).radius,net(1).longitude,net(1).latitude);
    for k=2:d,
      other=geo_to_cart(net(k).radius,net(k).longitude,net(k).latitude);
      edge=other-ref;
      wave=-sph_to_cart(ones(size(phi)),phi,theta);
      tmp=wave'*edge;
      tmp=reshape(tmp,size(phi));
      pd(:,:,k-1)=tmp;
    end;

  else
    pd=[];
  end;

  return;