##DWV	Discrete Wigner-Ville distribution.
##	[TFR,T,F]=DWV(X,IDX,FS) computes the discrete Wigner-Ville distribution.
## 
##	X     : signal if auto-WV, or [X1,X2] if cross-WV
##	IDX   : time indices (default : 1:length(X))
##	FS    : sampling frequency (default : 1)
##	TFR   : time-frequency representation
##	T     : time axis sampling
##	F     : frequency axis sampling

##
## Copyright (C) 2007 Eric Chassande-Mottin, Olivier Rabaste, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: dwv.m,v 1.2 2008/09/03 14:00:51 ecm Exp $

function [tfr,t,f] = dwv(x,idx,fs);

if (nargin < 1),
 error("dwv.m: at least one parameter is required");
end;

[N,xcol] = size(x);

if (nargin == 1),
  idx=1:N; fs=1;
elseif (nargin == 2),
  fs=1;
end;

if (xcol==0)|(xcol>2),
  error("X must have one or two columns");
elseif (2^nextpow2(N)~=N),
  error("N must be a power of two");
end; 

## create the interlaced signal and corresponding time vector

twoN=2*N;

xx=zeros(twoN,xcol);
xx(1:2:twoN-1,:)=x;
xx(2:2:twoN,:)=x;

tfr=lcf(xx,2*idx(:)'-1);
tfr= fft(tfr)/fs; 

if (xcol==1), tfr=real(tfr); end ;

if (nargout==2),
  t=idx/fs;
end;

if (nargout==3),
 f=fs*(0:twoN-1)'/twoN;
end;

