##DELAY   Delay in the arrival time at detectors
##        T=TOF(NET,PHI,THETA[,NORM_FLAG]) computes the delay in the arrival
##        time of a gravitational (plane) wave. The delay is calculated wrt
##        the first detector  in the network.
##
##        NET             :  network descriptor
##        PHI             :  source direction grid, azimut angle from x-axis
##        THETA           :  source direction grid, polar angle from zenith
##        NORM_FLAG       :  work with normalized units (c=1.0 ms^-1) [default=0, false]
##        T               :  time of flight (sec)
##

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the
## GNU General Public License (GPL), version 2, or at your
## option any later version.
##

## $Id: delay.m,v 1.4 2008/09/15 14:51:05 ecm Exp $

function t=delay(net,phi,theta,norm_flag)
  
  if (nargin<3)
    error("Usage: x=delay(net,phi,theta[,norm_flag])");
  end;

  if (nargin<4)
    norm_flag=0;
  end;

  if (norm_flag)
    c=1.0; ## work with normalized units
  else
    ## get speed of light from constants.m
    if !exist("__C_SI__","var")
      constants;
    endif;
    global __C_SI__;
    c=__C_SI__;
  end;

  t=proj_dist(net,phi,theta)/c;
  
  return;