
function data=dataread(typeFlag,fileName,format)

error(nargchk(3, 3, nargin));

if ~exist(fileName,"file")
  error("dataread.m: file not found");
endif;

fid=fopen(fileName,"r"); 
[rawText count]=fscanf(fid,"%c",Inf);
fclose(fid);

if (count>0)
  stringMatrix=split(deblank(rawText),"\n");
  r=length(strfind(format,"%"));
  c=rows(stringMatrix);
  buffer=cell(r,c);
  for n=1:c,
    [buffer{:,n}]=sscanf(stringMatrix(n,:),format,"C");
  endfor;
else
  buffer=[];
endif;

%% maps to cell array
data=cell(r,1);
for n=1:r,
  data{n}=cell(c,1);
  for m=1:c,
    data{n}{m}=buffer{n,m};
  endfor;
  %% convert to vector if numeric
  if isnumeric(data{n}{1}) 
    data{n}=[data{n}{:}];
  endif;
endfor;

endfunction