## Definition of physical constants

##
## Copyright (C) 2008 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: constants.m,v 1.2 2008/09/03 14:00:51 ecm Exp $

function constants(debugLevel)

if (nargin==0)
  debugLevel=0;
endif;

if (debugLevel>0)
  fprintf(1, "constants.m: define global constants");
endif;

global __C_SI__ = 299792458; %% Speed of light in vacuo, m s^-1

global __REARTH_SI__ = 6.378140e6;      %% Earth equatorial radius, m
global __AWGS84_SI__ = 6.378137e6;      %% Semimajor axis of WGS-84 Reference Ellipsoid, m
global __BWGS84_SI__ = 6.356752314e6;   %% Semiminor axis of WGS-84 Reference Ellipsoid, m

endfunction;