/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_VECTOROPS_H
#define _BCC_VECTOROPS_H

#include "factories.h"
#include "error.h"

#ifdef  __cplusplus
extern "C" {
#endif

  /* prototypes */

  void copy_vector(bcc_status*, vector *, const vector *);
  void copy_time_series(bcc_status*, time_series *, const time_series *);

  void reset_vector(bcc_status*, vector *);
  void reset_matrix(bcc_status*, matrix *);
  void reset_time_series(bcc_status*, time_series *);

  /* error management */

#define BCC_VECTOROPS_ENULL   1
#define BCC_VECTOROPS_EVECZ   2
#define BCC_VECTOROPS_EIRNG   3
#define BCC_VECTOROPS_EICSR   3
#define BCC_VECTOROPS_ETDSC   3

#define BCC_VECTOROPS_MSGENULL   "Null pointer."
#define BCC_VECTOROPS_MSGEVECZ   "Invalid vector size."
#define BCC_VECTOROPS_MSGEIRNG   "Invalid vector index."
#define BCC_VECTOROPS_MSGEICSR   "Inconsistent sampling rate."
#define BCC_VECTOROPS_MSGETDSC   "Time discontinuity."

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_VECTOROPS_H */
