/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#include "support.h"

static const char *bccName          = BCC_PACKAGE_NAME;
static const char *bccVersion       = BCC_VERSION;
static const int   bccVersionMajor  = BCC_VERSION_MAJOR;
static const int   bccVersionMinor  = BCC_VERSION_MINOR;
static const int   bccVersionMicro  = BCC_VERSION_MICRO;
static const char *bccConfigureArgs = BCC_CONFIGURE_ARGS;
static const char *bccConfigureDate = BCC_CONFIGURE_DATE;
static const char *bccCVSTag        = BCC_CVS_TAG;

void bcc_version( bcc_status *status, bcc_boolean verbose )
{
  int nchar;
  char infostr[BCCInfoLength];

  CHECKSTATUSPTR(status);

  nchar = verbose?
    sprintf( infostr, "This is %s Version %s\nCompiled on %s\n"
        "With arguments %s (RCS %s)\n",
        bccName, bccVersion, bccConfigureDate, bccConfigureArgs, bccCVSTag ) :
    sprintf( infostr, "This is %s Version %s\n", bccName, bccVersion ) ;

  if ( nchar <= 0 )
  {
    ABORT( status, SUPPORT_ESPRN, SUPPORT_MSGESPRN );
  }

  bcc_log(status,infostr);

  RETURN( status );
}

void bcc_read_debug_level(bcc_status *status, unsigned *level, const char *s )
{

  CHECKSTATUSPTR(status);

  *level = 0;

  if ( ! s )
  {
    if ( ! ( s = getenv( "BCC_DEBUG_LEVEL" ) ) )
      {
	bccDebugLevel = 0;
	RETURN (status); 
      }
  }

  /* skip whitespace */
  while ( isspace( *s ) )
    ++s;

  /* a value is set */
  if ( isdigit( *s ) )
    {
      bccDebugLevel = atoi( s );
      RETURN (status);
    }

  /* construct the debug level */
  if ( strstr( s, "NDEBUG" ) )
    *level |= BCCNDEBUG;
  if ( strstr( s, "ERROR" ) )
    *level |= BCCERROR;
  if ( strstr( s, "WARNING" ) )
    *level |= BCCWARNING;
  if ( strstr( s, "INFO" ) )
    *level |= BCCINFO;
  if ( strstr( s, "MSGLVL1" ) )
    *level |= BCCMSGLVL1;
  if ( strstr( s, "MSGLVL2" ) )
    *level |= BCCMSGLVL2;
  if ( strstr( s, "MSGLVL3" ) )
    *level |= BCCMSGLVL3;

  bccDebugLevel = *level;

  RETURN(status);
}
