/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_RESAMPLE_H
#define _BCC_RESAMPLE_H

#include "factories.h"
#include "error.h"
#include "vectorops.h"
#include "utils.h"

#include <math.h>

#ifdef  __cplusplus
extern "C" {
#endif

  typedef struct tagresampling_buffers{
    vector *proc;
    vector *left_over;
    vector *before;
    vector *after;
    matrix *interp;
  } resampling_buffers;

  typedef struct tagresampling_params{
    int decimate; 
    int interpolate; 
    double log10_reject; 
    double roll_off_width;
    double lower_cutoff_f;
    double upper_cutoff_f;
    double sample_rate;
  } resampling_params;

  /* state description */

  enum {RSP_INIT=0, RSP_OK=1};

  /* prototypes */
  void resample(bcc_status*, time_series *, resampling_buffers *, const time_series *, const resampling_params *);
  void smallest_block_size(bcc_status*, int*, const resampling_params*);
  void resample_init_buffer(bcc_status*, resampling_buffers*, const int, const resampling_params *);
  void resample_clear_buffer(bcc_status*, resampling_buffers*);
  void resample_purge_buffer(bcc_status*, resampling_buffers*);

  /* error management */

#define RSP_ENULL 1
#define RSP_EVECZ 1
#define RSP_EWINZ 2
#define RSP_EREGF 4
  
#define RSP_MSGENULL "Null pointer"
#define RSP_MSGEVECZ "Invalid vector size"
#define RSP_MSGEWINZ "Invalid window size"
#define RSP_MSGEREGF "Anti-aliasing cut-off frequency too large"

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_RESAMPLE_H */
