/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_PARSE_H
#define _BCC_PARSE_H

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <string.h>

#include "factories.h"
#include "error.h"

#ifdef  __cplusplus
extern "C" {
#endif

  /* constants */

  enum {BCCPrsLineLength=4096};

  typedef enum tagBCCParseType {BCCString,BCCBoolean,BCCReal,BCCInteger} BCCParseType;
  
  /* data structures */

  /* prototypes */
  void copy_file_to_buf(bcc_status*, char**, const char* );
  void parse(bcc_status*, bcc_boolean*, void *, const char *,const char*, const BCCParseType);
  
  /* status description */
  
  /* error management */
#define PRS_ENULL 0
#define PRS_EOPEN 1
#define PRS_EFILE 2
#define PRS_EREAD 3
#define PRS_ETYPE 4
#define PRS_ECLOS 5

#define PRS_MSGENULL "Null pointer"
#define PRS_MSGEOPEN "Error opening config file"
#define PRS_MSGEFILE "Config file is empty"
#define PRS_MSGEREAD "Error reading config file"
#define PRS_MSGECLOS "Error closing config file"
#define PRS_MSGETYPE "Unknown type"

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_PARSE_H */
