/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_FILTERING_H
#define _BCC_FILTERING_H

#include "factories.h"
#include "error.h"
#include "vectorops.h"
#include "utils.h"

#include <math.h>
#include <fftw3.h>

#ifdef  __cplusplus
extern "C" {
#endif

  typedef struct tagfiltering_buffers{
    vector *in;
    fftw_complex *out;
    vector *win;
    vector *raw, *proc;
    fftw_plan fwd, bck;
  } filtering_buffers;

  typedef struct tagfiltering_params{
    int block_length;
    int n_fft;
    int overlap_length;
    int flattop_edge_length;
    double lower_cutoff_f;
    double upper_cutoff_f;
    bcc_boolean use_surrogate_data;
  } filtering_params;

  /* prototypes */
  

  void filtering(bcc_status *, time_series *, filtering_buffers *, const time_series *, const vector *, const filtering_params *);
  void filtering_init_buffer(bcc_status*, filtering_buffers*, const int, const int, const int);
  void filtering_clear_buffer(bcc_status*, filtering_buffers*);

  /* state description */

  /* error management */

#define FLT_ENULL 1
#define FLT_EVECZ 2
#define FLT_EBLKZ 3
#define FLT_EFRQZ 4
#define FLT_EOVLZ 5
#define FLT_EAVGV 6

#define FLT_MSGENULL "Null pointer."
#define FLT_MSGEVECZ "Invalid vector size."
#define FLT_MSGEBLKZ "Invalid block size."
#define FLT_MSGEFRQZ "Invalid number of frequency bins."
#define FLT_MSGEOVLZ "Invalid overlap length."
#define FLT_MSGEAVGV "Invalid average factor."

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_FILTERING_H */
