/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_ERROR_H
#define _BCC_ERROR_H

#include "macros.h"

#ifdef  __cplusplus
extern "C" {
#endif

 typedef struct tagbcc_status{
   int code;
   const char *description;
   const char *function;
   const char *file;
   int line;
 } bcc_status;

  /* prototypes */
  int bcc_print_error(const char *, ... );
  void bcc_abort( const char *, ... );

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_ERROR_H */
