/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
/* \paragraph{Error messages} tell the operator that a computation has */
/* terminated abnormally, and has failed to produce an acceptable result. */
/* Normally this is associated with assigning a non-zero */
/* \verb@statusCode@; an error message is printed automatically whenever */
/* a function exits with non-zero \verb@statusCode@. */

/* \paragraph{Warning messages} tell the user that a computation is */
/* working, but with unusual behaviour that might indicate an unreliable */
/* or meaningless result.  Warnings do not normally result in a non-zero */
/* \verb@statusCode@. */

/* \paragraph{Information messages} tell the operator that the */
/* computation is proceeding as expected, and simply provide additional */
/* information about its progress. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#ifdef  __cplusplus
extern "C" {
#endif

#ifdef LAL_NDEBUG
#define vfprintf( stream, fmt, ap ) 0
#endif

int
bcc_print_error( const char *fmt, ... )
{ 
  int n;
  va_list ap;
  va_start( ap, fmt );
  n = vfprintf( stderr, fmt, ap );
  va_end( ap );
  return n;
}

void
bcc_abort( const char *fmt, ... )
{ 
  va_list ap;
  va_start( ap, fmt );
  (void) vfprintf( stderr, fmt, ap );
  va_end( ap );
  abort();
}

#ifdef  __cplusplus
}
#endif
