/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_H
#define _BCC_H

#include "factories.h"
#include "utils.h"
#include "error.h"
#include "dwv.h"

#include <math.h>

#ifdef  __cplusplus
extern "C" {
#endif
  
  /* data structures */

  typedef struct tagchirplet_chain{
    int length;
    int time_bin_length;
    int n_freq_bins;
    double score;
    double SNR;
    int * nodes;
  } chirplet_chain;

  typedef struct tagbcc_params{
    int time_bin_length;
    int n_time_bins;
    int n_freq_bins;
    int n_regul1;
    int n_regul2;
    int step;
    bcc_boolean input_is_matrix;
  } bcc_params;

  /* prototypes */
  
  void bcc(bcc_status*, chirplet_chain *, const  vector *, const bcc_params *);
  void create_chirplet_chain(bcc_status* , chirplet_chain** , int, int, int);
  void destroy_chirplet_chain(bcc_status* , chirplet_chain**);

  /* error management */

#define BCC_ENULL 1
#define BCC_ECCHZ 3
#define BCC_EVPTR 4
#define BCC_EUPTR 5
#define BCC_EDPTR 6
#define BCC_EMALLOC 7
#define BCC_EBLKZ 8
#define BCC_EINTZ 9
#define BCC_EFRQZ 10

#define BCC_MSGENULL "Null pointer"
#define BCC_MSGECCHZ "Invalid chirplet chain length"
#define BCC_MSGEVPTR "Null chirplet chain handle"
#define BCC_MSGEUPTR "Non-null chirplet chain pointer"
#define BCC_MSGEDPTR "Null chirplet chain data"
#define BCC_MSGEMALLOC  "Malloc failure"
#define BCC_MSGEBLKZ "Invalid lock size"
#define BCC_MSGEINTZ "Invalid interval size"
#define BCC_MSGEFRQZ "Invalid number of frequency bins"

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_H */
