/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_ESTIMATE_PSD_H
#define _BCC_ESTIMATE_PSD_H

#include <math.h>
#include "factories.h"
#include "utils.h"
#include "vectorops.h"
#include <fftw3.h>

#ifdef  __cplusplus
extern "C" {
#endif
  
  /* data structures */

  typedef struct tagPSD_buffers{
    vector *in;
    fftw_complex *out;
    fftw_plan plan;
    vector *win;
  } PSD_buffers;

  /* prototypes */
  
  void PSD_init_buffer(bcc_status*, PSD_buffers*, const int, const int);
  void PSD_estimate(bcc_status*, vector*, const time_series*, const PSD_buffers*, const int);

  /* error management */

#define PSD_ENULL 1
#define PSD_EVECZ 2
#define PSD_EBLKZ 3
#define PSD_EFRQZ 4

#define PSD_MSGENULL "Null pointer."
#define PSD_MSGEVECZ "Invalid vector size."
#define PSD_MSGEBLKZ "Invalid block size."
#define PSD_MSGEFRQZ "Invalid number of frequency bins."

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_ESTIMATE_PSD_H */
