/* 
*  This file is part of BCCsuite.
*
*  BCCsuite is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCCsuite is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _INIT_H
#define _INIT_H

#include "parse.h"
#include "pipeline.h"
#include "resample.h"
#include "filtering.h"

#ifdef  __cplusplus
extern "C" {
#endif

  /* data structures */

  /* prototypes */

  void parse_configuration(bcc_status*, io_params *, resampling_params **, filtering_params *, pipeline_params *, const char*);
  void check_and_adjust_params(bcc_status*, io_params *, resampling_params **, filtering_params *, pipeline_params *);

  /* error management */

#define INIT_ENULL 0
#define INIT_EPARS 1
#define INIT_EBUFZ 2
#define INIT_EDETNAME 3

#define INIT_MSGENULL "Null pointer"
#define INIT_MSGEPARS "Invalid configuration file"
#define INIT_MSGEBUFZ "Buffer size is too small"
#define INIT_MSGEDETNAME "Unknown detector name: recognised detector names are H1, H2, L1, V1, G1, T1"

#ifdef  __cplusplus
}
#endif

#endif /* _INIT_H */
