<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom>>

<\body>
  <apply|aboveTopic|oneStepTOC.tm><apply|windowTitle|Keeping track>
  <section|1.5. Keeping track>

  If an <apply|Language|> session has run for a while, you may lose track of
  the names of the objects which you have created. If this happens, try

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      )display names
    </input>

    <\output>
      Names of User-Defined Objects in the Workspace:

      % \ \ \ a \ \ \ b \ \ \ c \ \ \ i \ \ \ j \ \ \ k \ \ \ l \ \ \ 

      Names of System-Defined Objects in the Workspace:

      %e \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ %i
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ %infinity \ \ \ \ \ \ \ \ %minusInfinity
      \ \ \ 

      %pi \ \ \ \ \ \ \ \ \ \ \ \ \ \ %plusInfinity \ \ \ \ SF
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <with|prog language|axiom|this session|default|<\session>
    <\input|axiom] >
      \;
    </input>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Don't be alarmed at the first item, <verbatim|%> -- this is a variable used
  to hold the result of your most recent calculation (see section
  <apply|docLink|oneStep06.tm|1.6>). The ``System-Defined Objects'' are
  system <with|font shape|italic|macros> (see section
  <apply|docLink|../algebra/algebra07.tm|2.7>) put there for you by
  <apply|Language|>. To find out more about any object, say <verbatim|SF>,
  type

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      )display properties SF
    </input>

    <\output>
      Properties of SF :

      \ \ \ This is a system-defined macro.

      \ \ \ macro SF () == DoubleFloat()

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <vspace|1fn>You will find that it is a <with|font shape|italic|macro> -- in
  effect, an abbreviation -- for <with|font family|tt|DoubleFloat>, which is
  an <apply|Language|> type used to represent real numbers approximately in
  ``floating point'' form, using the ``double precision'' representation
  available on the type of computer on which <apply|Language|> is running. On
  most computers this means a representation with about 16 decimal digits of
  accuracy. <with|font family|tt|SF> originally stood for <with|font
  family|tt|SmallFloat>, in contrast to <apply|Language|>'s own <with|font
  family|tt|Float>s, which can be defined to have as many digits of accuracy
  as you wish; see section <apply|docLink|../algebra/algebra07.tm|2.7> for
  more details.

  The system macros beginning with <verbatim|%> correspond to the
  mathematical objects whose names follow the <verbatim|%> sign.

  Having discovered the names of the variables in use, you may decide that
  some of these -- say <verbatim|c> and <verbatim|i> -- are no longer
  necessary. They can be most simply removed as follows

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      )clear properties c i
    </input>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Recall that we declared <with|font family|tt|i> to have type <with|font
  family|tt|Integer> and gave it the value 2. The type
  declaration<apply|index|type!clearing> and value could have been cancelled
  separately, with <apply|hbox|<with|font family|tt|)clear mode i>> and
  <apply|hbox|<with|font family|tt|)clear value i>>, respectively. The
  keywords <with|font family|tt|properties>, <with|font family|tt|mode> and
  <with|font family|tt|value> may be abbreviated to their initial letters.

  Beware of typing commands such as <apply|hbox|<with|font family|tt|)clear
  a>> or <apply|hbox|<with|font family|tt|)clear c>> if you really mean
  <apply|hbox|<with|font family|tt|)clear value a>> etc. In particular,
  <apply|hbox|<with|font family|tt|)clear c>> is taken to mean
  <apply|hbox|<with|font family|tt|)clear completely>> and is quite thorough
  in doing so: try it once and see (then remember not to, in future).

  You can return to a completely ``clean slate'' without having to reload
  <apply|Language|>, by using the command <apply|hbox|<with|font
  family|tt|)clear all>> or <apply|hbox|<with|font family|tt|)clear a>>.
  However, code which has been loaded by <apply|Language|> is not removed in
  this process and so will not be reloaded if previously used commands are
  repeated.

  <apply|nextTopic|oneStep06.tm> <apply|previousTopic|oneStep04.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|type!clearing>|<pageref|idx-1>>
    </associate>
  </collection>
</auxiliary>
