<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom>>

<\body>
  <apply|aboveTopic|oneStepTOC.tm> <apply|windowTitle|Setting
  types><label|settype><section|1.4. Setting types><label|settype>

  Although <apply|Language|> will give the variable used in an assignment a
  type appropriate to the value of the expression, it is also possible for
  the user to fix the type of a variable. <vspace|1fn>

  For example:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      i : Integer
    </input>

    <\output>
      <apply|axiomtype|Void >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- remember that the name of the type must be appropriately capitalised.
  (The act of assigning a type to <with|font family|tt|i> does not return a
  value, and so the result is of type <with|font family|tt|Void>.)

  Once the type of a variable has been fixed in this way, only expressions
  which can be converted to the chosen type may be assigned to the variable:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      i := 2/3
    </input>

    <\output>
      \ 

      \ \ \ Cannot convert right-hand side of assignment

      \ \ \ 2

      \ \ \ -

      \ \ \ 3

      \ \ \ \ \ \ to an object of the type Integer of the left-hand side.

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      i := 4/2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|2<apply|leqno>(12)>
      </with>

      <apply|axiomtype|Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  (Note that the command number did not increase after the unsuccessful
  assignment, indicating that nothing has been changed by it.)

  It is also possible to combine a type declaration and an assignment into a
  single statement:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      c : PositiveInteger := 3
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|3<apply|leqno>(13)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  This is exactly equivalent to giving the type declaration and assignment
  separately.

  If several variables are to be declared to have the same type, this can be
  accomplished in a single statement, by separating each pair of names with a
  comma and enclosing them in parentheses, as in

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      (j, k, l) : Integer
    </input>

    <\output>
      <apply|axiomtype|Void >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- the parentheses are necessary to tell <apply|Language|> that the type
  declaration applies to all of <with|font family|tt|j>, <with|font
  family|tt|k> and <with|font family|tt|l>, not just to <with|font
  family|tt|l>.

  Whilst discussing types, we should note the use of the word <with|font
  shape|italic|domain><apply|index|domain>, which occurs widely in the
  <apply|Language|> literature. A domain may be thought of abstractly as the
  collection of all the possible objects of a particular type, so that the
  expressions ``has type <with|font shape|italic|Type1>'' and ``belongs to
  the domain <with|font shape|italic|Type1>'' are equivalent. It is also used
  to mean the collection of code in the <apply|Language|> system which
  defines an abstract domain.

  <apply|nextTopic|oneStep05.tm> <apply|previousTopic|oneStep03.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|settype|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|domain>|<pageref|idx-1>>
    </associate>
  </collection>
</auxiliary>
