<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom|axiom>>

<\body>
  <apply|aboveTopic|oneStepTOC.tm> <apply|windowTitle|Assignments><apply|index|assignment><label|assignments><section|1.3.
  Assignments><apply|index|assignment><label|assignments>

  So far, we have only evaluated expressions. Generally, we want to set up
  <with|font shape|italic|variables> to hold the values of the expressions,
  to reuse later. The operation of giving a value to a variable is known as
  <with|font shape|italic|assignment>. The simplest type of assignment in
  <apply|Language|> is <with|font shape|italic|immediate
  assignment><apply|index|immediate assignment><apply|index|assignment!immediate>,
  which has the form <with|font shape|italic|variable> <with|font
  family|tt|:=> <with|font shape|italic|expression>. In this, the value of
  the expression is calculated immediately and this becomes the value of the
  variable. For instance, if we have

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a := 2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|2<apply|leqno>(7)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      b := a
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|2<apply|leqno>(8)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  both <with|font family|tt|a> and <with|font family|tt|b> now have the value
  2 and each will continue to do so until its value is explicitly changed by
  another assignment. Changing the value of <with|font family|tt|a> does not
  affect <with|font family|tt|b>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a := 3
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|3<apply|leqno>(9)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      b
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|2<apply|leqno>(10)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  In some computer algebra systems, although assignments equivalent to these
  will have the same effect, reversing the order of commands <with|font
  family|tt|(6)> and <with|font family|tt|(7)> would cause <with|font
  family|tt|b> to depend on <with|font family|tt|a>, so that the final result
  at <with|font family|tt|(9)> would have been 3. This can be very confusing,
  even to experienced users. In <apply|Language|>, these two types of
  assignment are clearly distinguished. The second, known as <with|font
  shape|italic|deferred assignment><apply|index|deferred
  assignment><apply|index|assignment!deferred>, uses the operator <with|font
  family|tt|==> to establish a permanent relationship between a variable and
  an expression. We shall return to this in section
  <apply|docLink|../algebra/algebra07.tm|2.7>.

  Note that variable names<apply|index|name> (and other <with|font
  shape|italic|symbols>) usually begin with an alphabetic character and
  continue with alphabetic and numeric characters. Upper and lower
  case<apply|index|case> letters are distinct, so that <with|font
  family|tt|AB>, <with|font family|tt|Ab>, <with|font family|tt|aB> and
  <with|font family|tt|ab> are four different names. The characters
  <with|font family|tt|%> and <with|font family|tt|!> are also allowed in
  names, with <with|font family|tt|?> allowed in non-initial positions; these
  three characters can, however, have a special significance when they appear
  in certain positions. In <apply|Language|>, the
  underline<apply|index|underline> or underscore<apply|index|underscore>
  character <verbatim|_><apply|index|<rsub|@><verbatim|_>> is an
  escape<apply|index|escape character> character, so that <verbatim|A_B> is
  the same as <with|font family|tt|AB>.

  <apply|nextTopic|oneStep04.tm> <apply|previousTopic|oneStep02.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-10|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-11|<tuple|<uninit>|?>>
    <associate|idx-12|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|assignments|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|assignment>|<pageref|idx-1>>

      <tuple|<tuple|assignment>|<pageref|idx-2>>

      <tuple|<tuple|immediate assignment>|<pageref|idx-3>>

      <tuple|<tuple|assignment!immediate>|<pageref|idx-4>>

      <tuple|<tuple|deferred assignment>|<pageref|idx-5>>

      <tuple|<tuple|assignment!deferred>|<pageref|idx-6>>

      <tuple|<tuple|name>|<pageref|idx-7>>

      <tuple|<tuple|case>|<pageref|idx-8>>

      <tuple|<tuple|underline>|<pageref|idx-9>>

      <tuple|<tuple|underscore>|<pageref|idx-10>>

      <tuple|<tuple|<rsub|@><with|font family|<quote|tt>|language|<quote|verbatim>|_>>|<pageref|idx-11>>

      <tuple|<tuple|escape character>|<pageref|idx-12>>
    </associate>
  </collection>
</auxiliary>
