<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom|axiom>>

<\body>
  <apply|aboveTopic|oneStepTOC.tm><apply|windowTitle|Simple
  arithmetic><section|1.2. Simple arithmetic>

  Now let us try some simple calculations.(1)

  <with|prog language|axiom|this session|default|<\session>
    <\output>
      <\errput>
        \;
      </errput>
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      1+1
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|2<apply|leqno>(1)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  The user input is typed after the <with|mode|math|<with|color|red|\<rightarrow\>>>symbol.
  If you are using <TeXmacs> to view this tutorial and if you have Axiom
  installed, then you may try entering Axiom commands your self right now.
  Just position the cursor after the promt and trying typing a command, e.g.
  <with|mode|math|<with|color|blue|1+2>>.

  Note that as well as the answer <apply|Language|> gives its <with|font
  shape|italic|type><apply|index|type>, for future reference. The notion of
  types of expressions is fundamental to the way <apply|Language|> works, as
  will become apparent.

  One of the characteristics of computer algebra systems is their ability to
  handle numbers of <with|font shape|italic|arbitrary
  precision><apply|index|precision>, unlike conventional programming
  languages which are restricted to fixed levels of precision, such as ten or
  fewer digits in integers.

  <apply|Language|> is a typical computer algebra system in this respect --
  it does not restrict the number of digits allowed:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      123^45
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<expand|tabular*|<tformat|<table|<row|<cell|<with|formula
        style|true|11110408185131956285910790587176451918559153212268021823629>>>|<row|<cell|073199866111001242743283966127048043>>>>><apply|leqno>(2)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  but provides all the 95 digits necessary to express this result. (The
  <verbatim|^> represents exponentiation and may be read as ``to the power''.
  As in other languages, <with|font family|tt|**> may also be used to
  represent exponentiation.

  More complicated expressions may use parentheses to indicate the order in
  which they should be evaluated:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      2^(3+4)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|128<apply|leqno>(3)>
      </with>

      <apply|axiomtype|PositiveInteger >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  and, as in most languages, may sometimes be typed more simply using some
  built in rules of <with|font shape|italic|precedence><apply|index|precedence>:

  <apply|hspace*|5mm> <expand|tabular*|<tformat|<table|<row|<cell|
  \ exponentiation (<verbatim|^>) >|<cell| has higher precedence than (is
  done before) >>|<row|<cell| multiplication (<with|font family|tt|*>) and
  division (<with|font family|tt|/>) >|<cell| which have the same precedence,
  higher than >>|<row|<cell| addition (<with|font family|tt|+>) and
  subtraction (<with|font family|tt|-)> >|<cell| which again have the same
  precedence. >>>>>

  Operations with the same precedence are performed in the order in which
  they are input -- that is, from left to right.

  So far, the results of our operations have all been of type <with|font
  family|tt|PositiveInteger>, however, if we use division in our expression
  this is no longer the case:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      4/3
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|4|3><apply|leqno>(4)>
      </with>

      <apply|axiomtype|Fraction Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      2/2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|1<apply|leqno>(5)>
      </with>

      <apply|axiomtype|Fraction Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- although the second result is displayed as <with|font family|tt|1>,
  <apply|Language|> is telling us that it is really a fraction (whose
  components are integers). This kind of distinction can be important, since
  we can do things with fractions which are impossible if we only have
  integers (division being a case in point). In this simple case we are
  unlikely to be misled but, in more complicated situations, we could be.

  <apply|nextTopic|oneStep03.tm> <apply|previousTopic|oneStep01.tm>
</body>

<\initial>
  <\collection>
    <associate|preamble|false>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|type>|<pageref|idx-1>>

      <tuple|<tuple|precision>|<pageref|idx-2>>

      <tuple|<tuple|precedence>|<pageref|idx-3>>
    </associate>
  </collection>
</auxiliary>
