<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|More integrals>
  <section|3.8. More integrals>

  With <apply|Language|>'s integrator available, it is no longer necessary to
  resort to the miscellaneous selection of tricks usually learnt for handling
  awkward integrals. It would, perhaps, be reassuring to see how well
  <apply|Language|> does on some of these (classified by their possible
  methods of manual solution).

  <expand|subsection*|Logarithmic integrals><apply|index|integral!logarithmic>
  <apply|bogusAxiomLink|<verbatim|I(cot x, x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|2log <left|(><frac|sin <left|(>2x<right|)>|cos
  <left|(>2x<right|)>+1><right|)>-log <left|(><frac|2|cos
  <left|(>2x<right|)>+1><right|)>|2><apply|leqno>(43)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  The generality of <apply|Language|>'s integrator does, at times, cause it
  to produce rather inelegant results, such as this. However, it does provide
  us with the tools to simplify the expression, if we so desire. (For many
  applications, of course, the detailed form of the expression is unimportant
  -- what matters is that it is correct.)

  As we are dealing with real integrals, we can use the familiar
  transformations without compunction, when simplifying this result. There
  are many possible routes which we could follow, involving various
  logarithmic and trigonometric identities. Perhaps the most obvious starting
  point is to get rid of the double angles -- the function <with|font
  family|tt|normalize><apply|index|normalize@<verbatim|normalize>> will do
  this:

  <apply|bogusAxiomLink|<verbatim|normalize %>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|-log <left|(>tan
  <left|(>x<right|)><rsup|2>+1<right|)>+2log <left|(>tan
  <left|(>x<right|)><right|)>|2><apply|leqno>(44)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  Previous experience led to the choice of <with|font family|tt|normalize> in
  this case. The best way to find out what operations are available is to use
  the browser, described in chapter <apply|docLink|../tutorial/browse/browseTOC.tm|5
  The AXIOM browser> and in chapter 14 of the on-line guide to
  <apply|Language|>. Note that the quickest way to access the browser is to
  click on the return type. This will take you to the top browser page for
  that type.

  Noticing that this involves both <with|mode|math|tan x> itself and
  <with|mode|math|1+tan<rsup|2>x>, which is, of course,
  <with|mode|math|sec<rsup|2>x>, suggests that expressing it in terms of sin
  and cos may be helpful. This can be achieved with <with|font
  family|tt|simplify>:<apply|index|simplify@<verbatim|simplify>>

  <apply|bogusAxiomLink|<verbatim|simplify %>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|2log <left|(><frac|sin <left|(>x<right|)>|cos
  <left|(>x<right|)>><right|)>-log <left|(><frac|1|cos
  <left|(>x<right|)><rsup|2>><right|)>|2><apply|leqno>(45)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  Applying two of the standard rules for real logarithms:

  <apply|bogusAxiomLink|<verbatim|(rule N*log A + M*log B == log(A^N*B^M))
  %>|<vspace|0.5fn><format|new line><expand|equation*|<frac|log <left|(>sin
  <left|(>x<right|)><rsup|2><right|)>|2><apply|leqno>(46)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|(rule log(A^N) == N*log
  A)%>|<vspace|0.5fn><format|new line><expand|equation*|log <left|(>sin
  <left|(>x<right|)><right|)><apply|leqno>(47)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  we end up with the usual ``book form'' of this result. (Note that this,
  like the original result, would require adjustment by a complex constant,
  such as log(-1), to produce a real form when <with|mode|math|sin(x)> is
  negative.)

  <apply|nextTopic|calculus09.tm> <apply|previousTopic|calculus07.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|integral!logarithmic>|<pageref|idx-1>>

      <tuple|<tuple|normalize@<with|font family|<quote|tt>|language|<quote|verbatim>|normalize>>|<pageref|idx-2>>

      <tuple|<tuple|simplify@<with|font family|<quote|tt>|language|<quote|verbatim>|simplify>>|<pageref|idx-3>>
    </associate>
    <\associate|toc>
      3.8. More integrals<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
