<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Digression --
  rules><label|rules><apply|index|rule> <section|3.7. Digression --
  rules><label|rules><apply|index|rule>

  There are many relationships among mathematical functions which allow the
  same expression to be represented in a wide variety of ways. For instance,
  if we have an expression involving

  <\expand|equation*>
    <frac|1|c*o*s*A>
  </expand>

  we may prefer to represent this in terms of <with|font family|tt|sec A>.
  Similarly, if

  <\expand|equation*>
    %e<rsup|x>+%e<rsup|-x>
  </expand>

  appears, we may decide to choose a representation in terms of <with|font
  family|tt|cosh x>.

  <apply|Language|> allows us to control the form of individual expressions
  in at least two ways -- by applying operations from those packages such as
  <with|font family|tt|TrigonometricManipulations>,
  <apply|index|TrigonometricManipulations@<verbatim|TrigonometricManipulations>>
  which are briefly discussed in chapter <apply|docLink|../browser/browserTOC.tex|5
  The AXIOM browser>, and by applying <with|font shape|italic|rewrite
  rules><apply|index|rewrite rule> (henceforth simply called <with|font
  shape|italic|rules>).

  A rule takes the form <with|font family|tt|rule ><with|font
  shape|italic|expression1><with|font family|tt| == ><with|font
  shape|italic|expression2> and indicates that expressions of the form
  <with|font shape|italic|expression1> should be transformed into that of
  <with|font shape|italic|expression2> Note that, if an opening parenthesis
  appears immediately after the word <with|font family|tt|rule>, it must be
  matched by a closing parenthesis <with|font shape|italic|at the end of the
  rule>.

  Here again, <apply|Language|> gives much greater control than some other
  packages, which apply rules either universally or not at all: in
  <apply|Language|> the user applies a rule to a specific expression; the
  result remains in the transformed form thereafter. The simplest way to
  apply a rule to a single expression is to use the rule, enclosed in
  parentheses, as if it were a function.

  For instance, to convert the <with|font family|tt|atan> in the second
  component of the previous integral to <with|font family|tt|acot>:

  <apply|bogusAxiomLink|<verbatim|second %% 27>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|arctan <left|(><frac|x<sqrt|a>|a><right|)>|<sqrt|a>><apply|leqno>(29)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|(rule atan A == acot(1/A))
  %>|<vspace|0.5fn><format|new line><expand|equation*|<frac|a*c*o*t<left|(><frac|a|x<sqrt|a>><right|)>|<sqrt|a>><apply|leqno>(30)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  (We can re-rationalise this, if desired, by applying the function
  <with|font family|tt|ratDenom>.)<apply|index|ratDenom@<verbatim|ratDenom>>

  In this example, <with|font family|tt|second><apply|index|lists!components>
  was used to obtain the second component of the solution list;
  <verbatim|%.2> would have had the same effect, as would <verbatim|% 2> and
  the equivalent <verbatim|%(2)>Analogous functions <with|font
  family|tt|first><apply|index|first@<verbatim|first>> and <with|font
  family|tt|third><apply|index|third@<verbatim|third>> exist, although, in
  general, it is simpler just to use whichever of the other forms you prefer.

  If you wish to check that your recollection of an identity is correct,
  before applying it as a rule, first rewrite it in the form <with|font
  shape|italic|expression><with|font family|tt| = 0>; it can be shown that
  there is no <with|font shape|italic|general> procedure for checking the
  validity of such an assertion -- however, a trick which usually works for
  checking transcendental identities in <apply|Language|> is to integrate the
  left hand side: if the identity is correct, the integral should be a
  constant (possibly zero). In awkward cases, differentiating to obtain zero
  can provide a way of verifying that a complicated expression is indeed
  constant -- but this is rarely necessary. In the case of our <with|font
  family|tt|atan> relation we obtain zero immediately on integration,
  confirming the identity:

  <apply|bogusAxiomLink|<verbatim|I(atan x -
  acot(1/x),x)>|<vspace|0.5fn><format|new
  line><expand|equation*|0<apply|leqno>(31)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>|>

  If a rule is to be used repeatedly, it may be assigned to a
  variable<apply|index|rule!named> which can then be used like a function:

  <apply|bogusAxiomLink|<verbatim|atanRule := rule atan(A) ==
  acot(1/A)>|<vspace|0.5fn><format|new line><expand|equation*|arctan
  <left|(>A<right|)><with|mode|text|font family|rm|==
  >a*c*o*t<left|(><frac|1|A><right|)><apply|leqno>(32)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|RewriteRule\| ( \|Integer\| ) ( \|Integer\| ) ( \|Expression\| (
  \|Integer\| ) ) ))>|<verbatim|RewriteRule>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Integer\| ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Integer\| ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>) <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|atanRule atan x>|<vspace|0.5fn><format|new
  line><expand|equation*|a*c*o*t<left|(><frac|1|x><right|)><apply|leqno>(33)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  Sometimes it is necessary to restrict the applicability of a rule. For
  example, suppose we wished to define a rule (for real quantities) which
  would simplify square roots of even powers. Provided that
  <with|mode|math|n> itself is even, we can write
  <with|mode|math|<sqrt|x<rsup|2n>>> as <with|mode|math|x<rsup|n>>. (If
  <with|mode|math|n> is odd, applying this rule when <with|mode|math|x> is
  negative will result in a negative quantity but, for reals,
  <with|mode|math|<sqrt|<space|0.25spc> \ \ \ \ >> is defined as the positive
  square root.)

  A rule to accomplish this could be defined as:

  <apply|bogusAxiomLink|<verbatim|rSimp := rule(sqrt(x^(2*(n\|even? n))) ==
  x^n)>|<vspace|0.5fn><format|new line><expand|equation*|<sqrt|x<rsup|<left|(>2n<right|)>>><with|mode|text|font
  family|rm|== >x<rsup|n><apply|leqno>(34)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|RewriteRule\| ( \|Integer\| ) ( \|Integer\| ) ( \|Expression\| (
  \|Integer\| ) ) ))>|<verbatim|RewriteRule>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Integer\| ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Integer\| ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>) <vspace|1fn>|>

  The vertical bar may be read as ``such that'' and introduces a <with|font
  shape|italic|predicate>.

  We can now apply this rule:

  <apply|bogusAxiomLink|<verbatim|rSimp(sqrt(x^4))>|<vspace|0.5fn><format|new
  line><expand|equation*|x<rsup|2><apply|leqno>(35)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>> <apply|index|second@<verbatim|second>>

  <apply|bogusAxiomLink|<verbatim|rSimp(sqrt(x^6))>|<vspace|0.5fn><format|new
  line><expand|equation*|<sqrt|x<rsup|6>><apply|leqno>(36)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  Rules in <apply|Language|> can be surprisingly powerful: a rule applied to
  an expression involving an operator will be applied to the parameters of
  that operator and the result of the operation, as applied to the modified
  parameters, will form part of the final result, even if the presence of the
  operator is not apparent in the output form of the original expression.

  For instance, in section <apply|docLink|calculus03.tm|3.3 Back to
  differentiation> we obtained the standard result for differentiating a
  product of functions. If we wanted to apply that result to specific
  functions, we could do so by means of rules; (as we long since
  <verbatim|)clear>ed that result, we now need to set it up again):

  <apply|bogusAxiomLink|<verbatim|f := operator 'f; g := operator 'g; dprod
  := D(f(x)*g(x),x)>|<vspace|0.5fn><format|new
  line><expand|equation*|f<left|(>x<right|)>g<rsub|
  ><rsup|,><left|(>x<right|)>+g<left|(>x<right|)>f<rsub|
  ><rsup|,><left|(>x<right|)><apply|leqno>(37)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>> <apply|index|second@<verbatim|second>>

  <apply|bogusAxiomLink|<verbatim|(rule f x == sin
  x)%>|<vspace|0.5fn><format|new line><expand|equation*|sin
  <left|(>x<right|)>g<rsub| ><rsup|,><left|(>x<right|)>+g<left|(>x<right|)>cos
  <left|(>x<right|)><apply|leqno>(38)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|(rule g x == exp
  x)%>|<vspace|0.5fn><format|new line><expand|equation*|e<rsup|x>sin
  <left|(>x<right|)>+cos <left|(>x<right|)>e<rsup|x><apply|leqno>(39)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|Language|> handled the differentiation of the substituted functions
  correctly, even though these only appeared in the output form as ``primed''
  symbols, not explicitly showing the differential operator <with|font
  family|tt|D>.

  We can make a collection of rules into a single object (called a <with|font
  shape|italic|ruleset>)<apply|index|ruleset> if we follow the word
  <with|font family|tt|rule> by a block<apply|index|block> of rules
  (indicated here by enclosing them in parentheses):

  <apply|bogusAxiomLink|<verbatim|(rule (f x == sin x; g x == cos
  x))dprod>|<vspace|0.5fn><format|new line><expand|equation*|-sin
  <left|(>x<right|)><rsup|2>+cos <left|(>x<right|)><rsup|2><apply|leqno>(40)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  A rule or ruleset can, of course, be given a name; this may then be applied
  to an expression:

  <apply|bogusAxiomLink|<verbatim|substitutions := (rule (f x == sec x; g x
  == csc x))>|<vspace|0.5fn><format|new line><expand|equation*|<left|{>f<left|(>x<right|)><with|mode|text|font
  family|rm|== >sec <left|(>x<right|)>,<space|0.5spc>g<left|(>x<right|)><with|mode|text|font
  family|rm|== >csc <left|(>x<right|)><right|}><apply|leqno>(41)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Ruleset\| ( \|Integer\| ) ( \|Integer\| ) ( \|Expression\| (
  \|Integer\| ) ) ))>|<verbatim|Ruleset>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Integer\| ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Integer\| ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>) <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|substitutions
  dprod>|<vspace|0.5fn><format|new line><expand|equation*|csc
  <left|(>x<right|)>sec <left|(>x<right|)>tan <left|(>x<right|)>-cot
  <left|(>x<right|)>csc <left|(>x<right|)>sec
  <left|(>x<right|)><apply|leqno>(42)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|nextTopic|calculus08.tm> <apply|previousTopic|calculus06.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-10|<tuple|<uninit>|?>>
    <associate|idx-11|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-12|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-13|<tuple|<uninit>|?>>
    <associate|rules|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|rule>|<pageref|idx-1>>

      <tuple|<tuple|rule>|<pageref|idx-2>>

      <tuple|<tuple|TrigonometricManipulations@<with|font
      family|<quote|tt>|language|<quote|verbatim>|TrigonometricManipulations>>|<pageref|idx-3>>

      <tuple|<tuple|rewrite rule>|<pageref|idx-4>>

      <tuple|<tuple|ratDenom@<with|font family|<quote|tt>|language|<quote|verbatim>|ratDenom>>|<pageref|idx-5>>

      <tuple|<tuple|lists!components>|<pageref|idx-6>>

      <tuple|<tuple|first@<with|font family|<quote|tt>|language|<quote|verbatim>|first>>|<pageref|idx-7>>

      <tuple|<tuple|third@<with|font family|<quote|tt>|language|<quote|verbatim>|third>>|<pageref|idx-8>>

      <tuple|<tuple|rule!named>|<pageref|idx-9>>

      <tuple|<tuple|second@<with|font family|<quote|tt>|language|<quote|verbatim>|second>>|<pageref|idx-10>>

      <tuple|<tuple|second@<with|font family|<quote|tt>|language|<quote|verbatim>|second>>|<pageref|idx-11>>

      <tuple|<tuple|ruleset>|<pageref|idx-12>>

      <tuple|<tuple|block>|<pageref|idx-13>>
    </associate>
    <\associate|toc>
      3.7. Digression -- rules<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
