<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Mathematical
  experimentation -- an example> <section|3.5. Mathematical experimentation
  -- an example>

  <apply|Language|> can also integrate more general expressions, involving
  variables other than the variable of integration. For example:

  <apply|bogusAxiomLink|<verbatim|I(x^n,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|x*e<rsup|<left|(>n*log
  <left|(>x<right|)><right|)>>|n+1><apply|leqno>(17)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  The form of the results from <apply|Language|>'s integrations may sometimes
  be a little unexpected -- but they have the advantage of generality, being
  valid (at least in the limit) for any values of the variables at which the
  result and the concept of an indefinite integral are defined.

  With <with|font family|tt|x> restricted to well-behaved values (those not
  lying at the origin or on the negative real axis) and <with|font
  family|tt|n> a real number other than <with|font family|tt|->1, the last
  result simply reduces to the familiar <verbatim|x^(n+1)/(n+1)>. To
  investigate its behaviour when <with|font family|tt|n> is <with|font
  family|tt|-1>, first subtract <with|font family|tt|1/(n+1)>, which is
  permissible since the integral implicitly includes an arbitrary constant:

  <apply|bogusAxiomLink|<verbatim|% - 1/(n + 1)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|x*e<rsup|<left|(>n*log
  <left|(>x<right|)><right|)>>-1|n+1><apply|leqno>(18)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  We cannot evaluate this if <with|font family|tt|n> is <verbatim|-1> -- we
  can, however, take its limit at that point:

  <apply|bogusAxiomLink|<verbatim|limit(%,n=-1)>|<vspace|0.5fn><format|new
  line><expand|equation*|log <left|(>x<right|)><apply|leqno>(19)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) (
  \|Record\| ( \|:\| ( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| (
  \|Integer\| ) ) ) failed ) ) ( \|:\| ( \|Union\| ( \|OrderedCompletion\| (
  \|Expression\| ( \|Integer\| ) ) ) failed ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>, Record(leftHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>> (<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>), rightHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>)),<verbatim|failed>)
  <vspace|1fn>>

  so that the integral of <with|font family|tt|1/x>, which is usually
  introduced as a special case, is just a limiting case of the general
  result.

  In the above development, we followed the usual mathematics textbook
  approach of pulling the necessary transformation out of a hat, the only
  justification being that it worked. One of the great advantages of computer
  algebra systems is that they allow us to explore and experiment with
  mathematical objects relatively quickly: the following reconstruction of
  the steps which led us to subtract <with|font family|tt|1/(n+1)>
  illustrates this process.

  <apply|bogusAxiomLink|<verbatim|In := %% 17>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|x*e<rsup|<left|(>n*log
  <left|(>x<right|)><right|)>>|n+1><apply|leqno>(20)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|limit(%,n=-1)>|<vspace|0.5fn><format|new
  line><expand|equation*|<left|[>l*e*f*t*H*a*n*d*L*i*m*i*t=-i*n*f*i*n*i*t*y,<space|0.5spc>r*i*g*h*t*H*a*n*d*L*i*m*i*t=+i*n*f*i*n*i*t*y<right|]><apply|leqno>(21)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) (
  \|Record\| ( \|:\| ( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| (
  \|Integer\| ) ) ) failed ) ) ( \|:\| ( \|Union\| ( \|OrderedCompletion\| (
  \|Expression\| ( \|Integer\| ) ) ) failed ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>, Record(leftHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>> (<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>), rightHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>)),<verbatim|failed>)
  <vspace|1fn>|>

  Looking at the series expansion can show where the infinity comes from:

  <apply|bogusAxiomLink|<verbatim|)set stream calculate
  5>|<vspace|0.5fn><vspace|1fn><apply|bgroup><with|font
  size|0.84|<apply|color|blue> <vspace|1fn><apply|egroup><vspace|1fn>>|>

  <apply|bogusAxiomLink|<verbatim|series(In,n=-1) \ \ \ \ \ \ \ \ \ --
  \ expand In in powers of (n+1)>|<vspace|0.5fn><format|new
  line><expand|equation*|x*e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>><left|(>n+1<right|)><rsup|<left|(>-1<right|)>>+x*log
  <left|(>x<right|)>e<rsup|<left|(>-log <left|(>x<right|)><right|)>>+<frac|x*log
  <left|(>x<right|)><rsup|2>e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>>|2><left|(>n+1<right|)>+<frac|x*log
  <left|(>x<right|)><rsup|3>e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>>|6><left|(>n+1<right|)><rsup|2>+<frac|x*log
  <left|(>x<right|)><rsup|4>e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>>|24><left|(>n+1<right|)><rsup|3>+<frac|x*log
  <left|(>x<right|)><rsup|5>e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>>|120><left|(>n+1<right|)><rsup|4>+O<left|(><left|(>n+1<right|)><rsup|5><right|)><apply|leqno>(22)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|UnivariatePuiseuxSeries\| ( \|Expression\| ( \|Integer\| ) ) (QUOTE
  \ \|n\| ) (QUOTE \ ( ( 0 \ . \ -1 ) \ \ 0 \ . \ 1 ) )
  ))>|<verbatim|UnivariatePuiseuxSeries>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,n,<verbatim|-1>) <vspace|1fn>|>

  The first term of the series is the only one involving a negative power of
  <with|font family|tt|(n + 1)> and so the only one to become infinite at
  <with|font family|tt|n = -1>. For well-behaved values of <with|font
  family|tt|x>, the expression

  <verbatim|><apply|break> <verbatim| \ \ \ \ \ \ \ \ - log(x)><apply|break>
  <verbatim| \ \ \ \ x %e><apply|break>

  reduces to <with|font family|tt|1> and the term depends only on <with|font
  family|tt|n>. These facts suggest that subtracting the ``simplified''
  version of this term, <with|font family|tt|1/(n + 1)>, as an adjustment of
  the constant of integration, might be a useful approach (and, in fact, we
  already saw that it works).

  On the other hand, if we only noticed, initially, that the first term was
  the probable cause of the infinite limit, we might try subtracting it in
  the form it appeared in the series:

  <apply|bogusAxiomLink|<verbatim|In2 := In -
  x*%e^(-log(x))*(n+1)^(-1)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|x*e<rsup|<left|(>n*log
  <left|(>x<right|)><right|)>>-x*e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>>|n+1><apply|leqno>(23)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|limit(In2,n=-1)>|<vspace|0.5fn><format|new
  line><expand|equation*|x*log <left|(>x<right|)>e<rsup|<left|(>-log
  <left|(>x<right|)><right|)>><apply|leqno>(24)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) (
  \|Record\| ( \|:\| ( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| (
  \|Integer\| ) ) ) failed ) ) ( \|:\| ( \|Union\| ( \|OrderedCompletion\| (
  \|Expression\| ( \|Integer\| ) ) ) failed ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>, Record(leftHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>> (<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>), rightHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>)),<verbatim|failed>)
  <vspace|1fn>|>

  Now, of course, having seen that this subtraction has the desired effect we
  would be motivated to examine its form more closely and no doubt try the
  effect of the simpler expression to which it usually reduces.

  Incidentally, does the same trick work with the standard result?

  <apply|bogusAxiomLink|<verbatim|limit(x^(n+1)/(n+1),n=-1)>|<vspace|0.5fn><format|new
  line><expand|equation*|<left|[>l*e*f*t*H*a*n*d*L*i*m*i*t=-i*n*f*i*n*i*t*y,<space|0.5spc>r*i*g*h*t*H*a*n*d*L*i*m*i*t=+i*n*f*i*n*i*t*y<right|]><apply|leqno>(25)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) (
  \|Record\| ( \|:\| ( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| (
  \|Integer\| ) ) ) failed ) ) ( \|:\| ( \|Union\| ( \|OrderedCompletion\| (
  \|Expression\| ( \|Integer\| ) ) ) failed ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>, Record(leftHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>> (<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>), rightHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>)),<verbatim|failed>)
  <vspace|1fn>> <apply|index|atan@<verbatim|atan>>

  <apply|bogusAxiomLink|<verbatim|limit(x^(n+1)/(n+1)-1/(n+1),n=-1)>|<vspace|0.5fn><format|new
  line><expand|equation*|log <left|(>x<right|)><apply|leqno>(26)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) (
  \|Record\| ( \|:\| ( \|Union\| ( \|OrderedCompletion\| ( \|Expression\| (
  \|Integer\| ) ) ) failed ) ) ( \|:\| ( \|Union\| ( \|OrderedCompletion\| (
  \|Expression\| ( \|Integer\| ) ) ) failed ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>, Record(leftHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>> (<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>), rightHandLimit:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Union\| (
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) ) ) failed
  ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|OrderedCompletion\| ( \|Expression\| ( \|Integer\| ) )
  ))>|<verbatim|OrderedCompletion>> <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<verbatim|failed>)),<verbatim|failed>)
  <vspace|1fn>|>

  Yes, it does. Some texts, in fact, introduce a function <with|mode|math|ln>
  (on the positive reals) defined as this limit, then show that it coincides
  with <with|mode|math|log<rsub|e>>.

  <apply|nextTopic|calculus06.tm> <apply|previousTopic|calculus04.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|atan@<with|font family|<quote|tt>|language|<quote|verbatim>|atan>>|<pageref|idx-1>>
    </associate>
    <\associate|toc>
      3.5. Mathematical experimentation -- an
      example<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
