<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Integration><label|integration><apply|index|integration>
  <section|3.4. Integration><label|integration><apply|index|integration>

  <apply|Language|> offers what is probably the most comprehensive package
  for analytic integration currently in existence.

  Integrals, of course, are indeterminate to within an additive constant so
  the form of the integral returned by <apply|Language|> may not always be
  familiar: the choice of a particular constant can have a surprisingly
  strong effect on the form. The moral is that a range of methods can be
  applied to most integration problems and the results which they produce can
  look very different. The optimal form of an integral will depend on the use
  which is to be made of it -- users may wish to exercise their own judgement
  in this. However, the form which <apply|Language|> returns can be relied
  upon to be correct, even if it seems awkward at times.

  Many of the examples in the following sections were based on Green's
  ``Advanced Level Pure Mathematics'' To demonstrate that <apply|Language|>
  is familiar with some basic integrals:

  <apply|bogusAxiomLink|<verbatim|)clear p x -- since x has a
  value>|<vspace|0.5fn><vspace|1fn><apply|bgroup><with|font size|0.84|
  <vspace|1fn><apply|egroup><vspace|1fn>>>

  <apply|bogusAxiomLink|<verbatim|integrate(x^2,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|1|3>x<rsup|3>><format|new
  line><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Polynomial\| ( \|Fraction\| ( \|Integer\| ) )))>|<verbatim|Polynomial>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Fraction\| ( \|Integer\|
  )<format|next line> ))>|<verbatim|Fraction>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Int<format|next line>eger>> |>

  <apply|bogusAxiomLink|<verbatim|integrate(%e^x,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|e<rsup|x><apply|leqno>(11)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  (<with|font family|tt|%e> is <apply|Language|>'s representation of the
  exponential base <with|mode|math|e>).<apply|index|e@<with|mode|math|e>><apply|index|exponential
  base>

  <apply|bogusAxiomLink|<verbatim|integrate(1/x,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|log <left|(>x<right|)><apply|leqno>(12)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|integrate(sin
  x,x)>|<vspace|0.5fn><format|new line><expand|equation*|-cos
  <left|(>x<right|)><apply|leqno>(13)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>>

  It can quickly become boring to type <with|font family|tt|integrate> each
  time, so let us define a macro (see section 2.6) which will allow us to use
  I as an abbreviation for this, by analogy with D:

  <apply|bogusAxiomLink|<verbatim|I ==\<gtr\>
  integrate>|<vspace|0.5fn><vspace|1fn><apply|break|>Type:
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Void\|
  ))>|<verbatim|Void>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|I(x^3,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|1|4>x<rsup|4><apply|leqno>(15)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Polynomial\| ( \|Fraction\| ( \|Integer\| ) )
  ))>|<verbatim|Polynomial>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Fraction\| ( \|Integer\| ) ))>|<verbatim|Fraction>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>|>

  <apply|bogusAxiomLink|<verbatim|I(sin sin x,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<big|int><rsup|<with|formula style|true|x>>sin
  <left|(>sin <left|(>%Q<right|)><right|)>d%Q<apply|leqno>(16)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Union\| ( \|Expression\| ( \|Integer\| ) ) ( \|List\| ( \|Expression\|
  ( \|Integer\| ) ) ) ))>|<verbatim|Union>>(<apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>>,<apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|List\| ( \|Expression\| ( \|Integer\| ) ) ))>|<verbatim|List>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Expression\| ( \|Integer\|
  ) ))>|<verbatim|Expression>> <apply|bogusLispLink|<verbatim|(\|conPage\| '(
  \|Integer\| ))>|<verbatim|Integer>>) <vspace|1fn>|>

  Returning a <with|font shape|italic|formal integral> means that
  <apply|Language|> cannot find a ``closed form'' -- that is, a finite
  expression -- for the integral. This is not a catastrophe -- many commonly
  used functions of applied mathematics are defined only as integrals of some
  other function. Beware of typing <with|font
  family|tt|integral><apply|index|integral@<verbatim|integral>> if you mean
  <with|font family|tt|integrate>: <with|font family|tt|integral> always
  returns an expression of this type. <with|font family|tt|integrate> only
  returns a formal integral when it can be proved that no closed form exists
  in terms of <with|font shape|italic|elementary> functions. That is,
  functions formed by a finite number of applications of the arithmetic
  operators, powers, roots, trigonometric and inverse trigonometric
  functions, exponentials and logarithms to a finite set of constants and
  variables.

  The other new symbol in expression (16), <with|font family|tt|%Q>, is
  simply a variable name generated by <apply|Language|>. By using these
  automatically generated symbols <apply|Language|> ensures that the integral
  is in its most general form.

  <apply|nextTopic|calculus05.tm> <apply|previousTopic|calculus03.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|integration|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|integration>|<pageref|idx-1>>

      <tuple|<tuple|integration>|<pageref|idx-2>>

      <tuple|<tuple|e@<with|mode|<quote|math>|e>>|<pageref|idx-3>>

      <tuple|<tuple|exponential base>|<pageref|idx-4>>

      <tuple|<tuple|integral@<with|font family|<quote|tt>|language|<quote|verbatim>|integral>>|<pageref|idx-5>>
    </associate>
    <\associate|toc>
      3.4. Integration<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
