<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial>>

<\body>
  <apply|aboveTopic|calculusTOC.tm><apply|windowTitle|Differentiation><apply|index|differentiation>
  <section|3.1. Differentiation><apply|index|differentiation>

  In <apply|Language|>, the operator <with|font
  family|tt|D><apply|index|D@<verbatim|D>> is used to obtain the
  derivative<apply|index|derivative> of its first argument with respect to
  its second:

  <apply|bogusAxiomLink|<verbatim|D(x^2,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|2x<apply|leqno>(1)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Polynomial\| ( \|Integer\| ) ))>|<verbatim|Polynomial>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|pagebreak>

  <apply|bogusAxiomLink|<verbatim|D(sin x,x)>|<vspace|0.5fn><format|new
  line><expand|equation*|cos <left|(>x<right|)><apply|leqno>(2)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|D(sin(log(x/tan(x))),x)>|<vspace|0.5fn><format|new
  line><expand|equation*|<frac|<left|(>-x*tan <left|(>x<right|)><rsup|2>+tan
  <left|(>x<right|)>-x<right|)>cos <left|(>log <left|(><frac|x|tan
  <left|(>x<right|)>><right|)><right|)>|x*tan
  <left|(>x<right|)>><apply|leqno>(3)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  Higher order derivatives may be obtained by giving the order as a third
  argument. For instance, the second and third derivatives of
  <with|mode|math|tan x> are:

  <apply|bogusAxiomLink|<verbatim|D(tan x,x,2)>|<vspace|0.5fn><format|new
  line><expand|equation*|2tan <left|(>x<right|)><rsup|3>+2tan
  <left|(>x<right|)><apply|leqno>(4)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  <apply|bogusAxiomLink|<verbatim|D(tan x,x,3)>|<vspace|0.5fn><format|new
  line><expand|equation*|6tan <left|(>x<right|)><rsup|4>+8tan
  <left|(>x<right|)><rsup|2>+2<apply|leqno>(5)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  If the expression given by the first parameter depends on more than one
  variable, <apply|Language|> calculates the partial
  derivative<apply|index|partial derivative><apply|index|derivative!partial>
  with respect to the variable identified in the second parameter. Thus, to
  obtain

  <\expand|equation*>
    <frac|\<partial\>sin(x*y)|\<partial\>x>
  </expand>

  <apply|bogusAxiomLink|<verbatim|D(sin(x*y),x)>|<vspace|0.5fn><format|new
  line><expand|equation*|y*cos <left|(>x*y<right|)><apply|leqno>(6)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  However, for mixed partial derivatives, we must specify a list of the
  variables of differentiation, in the order in which they are to be applied.
  For instance, to calculate

  <\expand|equation*>
    <frac|\<partial\><rsup|3>sinx*y|\<partial\>x<rsup|2>\<partial\>y>
  </expand>

  <apply|bogusAxiomLink|<verbatim|D(sin(x*y),[y,x,x])>|<vspace|0.5fn><format|new
  line><expand|equation*|-2y*sin <left|(>x*y<right|)>-x*y<rsup|2>cos
  <left|(>x*y<right|)><apply|leqno>(7)><format|new
  line><vspace|1fn><apply|break|>Type: <apply|bogusLispLink|<verbatim|(\|conPage\|
  '( \|Expression\| ( \|Integer\| ) ))>|<verbatim|Expression>>
  <apply|bogusLispLink|<verbatim|(\|conPage\| '( \|Integer\|
  ))>|<verbatim|Integer>> <vspace|1fn>>

  (The call <verbatim|D(sin(x*y),[y,x],[1,2])> provides an alternative way of
  obtaining the same effect.)

  We can also experiment with differentiating more complex forms, involving,
  for instance, the product and quotient of functions (<with|mode|math|f(x)>
  and <with|mode|math|g(x)>, say) and their composition,
  <with|mode|math|f(g(x))>. To explore this area in a general setting, we
  first need to meet <apply|Language|>'s representation of arbitrary
  functions as <with|font shape|italic|operators>.

  <apply|nextTopic|calculus02.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|differentiation>|<pageref|idx-1>>

      <tuple|<tuple|differentiation>|<pageref|idx-2>>

      <tuple|<tuple|D@<with|font family|<quote|tt>|language|<quote|verbatim>|D>>|<pageref|idx-3>>

      <tuple|<tuple|derivative>|<pageref|idx-4>>

      <tuple|<tuple|partial derivative>|<pageref|idx-5>>

      <tuple|<tuple|derivative!partial>|<pageref|idx-6>>
    </associate>
    <\associate|toc>
      3.1. Differentiation<value|toc-dots><pageref|toc-1>
    </associate>
  </collection>
</auxiliary>
