<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|Summation of
  series><apply|index|summation of series> <section|2.5. Summation of
  series><apply|index|summation of series>

  <apply|index|series!summation>

  We can use <apply|Language|> to sum a variety of series,such as we might
  encounter in a basic algebra course. For instance, to find the sum of the
  first n terms of the series:

  <\expand|equation*>
    <frac|1|1\<times\>4\<times\>7>+<frac|1|4\<times\>7\<times\>10>+<apply|dots>+<frac|1|(3r-2)(3r+1)(3r+4)>+<apply|dots>
  </expand>

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      )clear p all
    </input>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <with|prog language|axiom|this session|default|<\session>
    <\input|axiom] >
      \;
    </input>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      sum(1/((3*r-2)*(3*r+1)*(3*r+4)), r=1..n)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|3n<rsup|2>+5n|72n<rsup|2>+120n+32><apply|leqno>(44)>
      </with>

      <apply|axiomtype|Union(Fraction Polynomial Integer,...) >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <apply|index|sum@<verbatim|sum>>To find the sum to infinity<apply|index|sum
  to infinity><apply|index|limit@<verbatim|limit>><apply|index|infinity!sum
  to><apply|index|plusInfinity@<verbatim|%plusInfinity>> of the same series:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      limit(%, n=%plusInfinity)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|1|24><apply|leqno>(45)>
      </with>

      <apply|axiomtype|Union(OrderedCompletion Fraction Polynomial
      Integer,...) >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  The type returned by <with|font family|tt|sum> was <with|font
  family|tt|Union(Fraction Polynomial Integer,Expression Integer)> -- an
  object is in a <with|font family|tt|Union><apply|index|union@<verbatim|Union>>
  of types if it is guaranteed to belong to one of the branches. Users may,
  of course assign this to a variable of a type not involving <with|font
  family|tt|Union>. The <with|font family|tt|OrderedCompletion><apply|index|orderedcompletion@<verbatim|OrderedCompletion>>
  mentioned in the <with|font family|tt|limit>'s type is the result of
  joining <with|mode|math|-\<infty\>> and <with|mode|math|\<infty\>> to the
  type <with|font family|tt|Fraction Polynomial Integer>. Finally, the
  ``failed'' branch of the <with|font family|tt|Union> represents the
  circumstance where no result may be returned, i.e. the limit does not
  exist.

  Having encountered the notion of series summation, we may turn to some
  commonly encountered series, such as arithmetic progressions (APs). If the
  initial term of an AP is <with|font family|tt|a> and the increment is
  <with|font family|tt|b> then the <with|font family|tt|r>th term is
  <with|mode|math|a+(r-1)\<ast\>b> and the sum of the first <with|font
  family|tt|n> terms can be found by:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      SA := sum(a + (r-1)*b, r = 1..n)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|b*n<rsup|2>+<left|(>-b+2a<right|)>n|2><apply|leqno>(46)>
      </with>

      <apply|axiomtype|Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <inactive|>This is probably not the most familiar form of this result.
  However, we can, if we wish, adjust its form by using some of the methods
  met in the previous section:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      SA :: UP(a, Polynomial Fraction Integer)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|n*a+<frac|1|2>b*n<rsup|2>-<frac|1|2>b*n<apply|leqno>(47)>
      </with>

      <apply|axiomtype|UnivariatePolynomial(a,Polynomial Fraction Integer) >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      <verbatim|SA :: UP(a, UP(b, FRAC FR POLY INT))>
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|n*a+<frac|<left|(>n-1<right|)>n|2>b<apply|leqno>(48)>
      </with>

      Type: UnivariatePolynomial(a,UnivariatePolynomial(b,Fraction Factored
      Polynomial Integer))

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  We can also sum a geometric progression:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      <verbatim|SG := sum(a*b^(r-1), r=1..n)>
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|a*b*b<rsup|<left|(>n-1<right|)>>-a|b-1><apply|leqno>(49)>
      </with>

      <apply|axiomtype|Expression Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  This is of type <with|font family|tt|Expression Integer>. Expressions are
  more complicated than polynomials in that they can involve fractions and
  various kinds of functions. We shall meet them again, later on.

  <apply|nextTopic|algebra06.tm> <apply|previousTopic|algebra04.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-10|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|summation of series>|<pageref|idx-1>>

      <tuple|<tuple|summation of series>|<pageref|idx-2>>

      <tuple|<tuple|series!summation>|<pageref|idx-3>>

      <tuple|<tuple|sum@<with|font family|<quote|tt>|language|<quote|verbatim>|sum>>|<pageref|idx-4>>

      <tuple|<tuple|sum to infinity>|<pageref|idx-5>>

      <tuple|<tuple|limit@<with|font family|<quote|tt>|language|<quote|verbatim>|limit>>|<pageref|idx-6>>

      <tuple|<tuple|infinity!sum to>|<pageref|idx-7>>

      <tuple|<tuple|plusInfinity@<with|font
      family|<quote|tt>|language|<quote|verbatim>|%plusInfinity>>|<pageref|idx-8>>

      <tuple|<tuple|union@<with|font family|<quote|tt>|language|<quote|verbatim>|Union>>|<pageref|idx-9>>

      <tuple|<tuple|orderedcompletion@<with|font
      family|<quote|tt>|language|<quote|verbatim>|OrderedCompletion>>|<pageref|idx-10>>
    </associate>
  </collection>
</auxiliary>
