<TeXmacs|1.0.2>

<style|<tuple|help|axiom-tutorial|axiom>>

<\body>
  <apply|aboveTopic|algebraTOC.tm><apply|windowTitle|Rearranging
  expressions><label|rearrange><section|2.4. Rearranging
  expressions><label|rearrange>

  One of the most basic things we learn from algebra is a facility for
  reorganising symbolic expressions into more convenient forms. However, many
  computer algebra systems will either stubbornly refuse to express a result
  in the form we want or will only do so after a selection of obscure
  switches has been set, which usually results in some other expression
  taking an undesired form.

  <apply|Language|>'s type system provides a much more sensitive mechanism
  for converting the forms of expressions, since it allows us to control the
  type of individual objects. What is more, it is much easier to learn than
  an arbitrary collection of switches, having a simple, consistent and
  mnemonic approach.

  We saw in section <apply|docLink|../oneStep/oneStep04.tm|1.4 Setting Types>
  how we could fix the type of a variable with the <with|font family|tt|:>
  operator. It is also possible to manipulate the type of an expression with
  the <with|font family|tt|::> operator:<apply|index|::@<verbatim|::>><apply|index|type!conversion><apply|index|conversion!type>
  <apply|index|manipulation!type><apply|index|transformation!type>

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a := (x+ y)/2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|1|2>y+<frac|1|2>x<apply|leqno>(31)>
      </with>

      <apply|axiomtype|Polynomial Fraction Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <apply|Language|> has obligingly separated the coefficients of <with|font
  family|tt|x> and <with|font family|tt|y> for us and the type reflects this
  -- the object is a <with|font shape|italic|polynomial> whose coefficients
  are <with|font shape|italic|fraction>s of <with|font
  shape|italic|integers>; if we want to insist on the form which we first
  input, this can easily be achieved -- what we want is a <with|font
  shape|italic|fraction> of <with|font shape|italic|polynomial>s whose
  coefficients are <with|font shape|italic|integers>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a:: Fraction Polynomial Integer
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|y+x|2><apply|leqno>(32)>
      </with>

      <apply|axiomtype|Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  However, note that we have not changed <with|font family|tt|a> since our
  instruction did not involve an assignment:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|1|2>y+<frac|1|2>x<apply|leqno>(33)>
      </with>

      <apply|axiomtype|Polynomial Fraction Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  -- to change the type of <with|font family|tt|a> by this method, we must
  assign the result to <with|font family|tt|a>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a := a :: Fraction Polynomial Integer
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|y+x|2><apply|leqno>(34)>
      </with>

      <apply|axiomtype|Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|y+x|2><apply|leqno>(35)>
      </with>

      <apply|axiomtype|Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  (We shall shortly see how to control the order of the variables <with|font
  family|tt|x> and <with|font family|tt|y>.)

  We have met a more compact method of setting the type of a variable. First
  resetting <with|font family|tt|a>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a := (x+y)/2;
    </input>

    <\output>
      <apply|axiomtype|Polynomial Fraction Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  we can assign its value to a variable of the desired type:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      <verbatim|b : Fraction Polynomial Integer := a>
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<frac|y+x|2><apply|leqno>(37)>
      </with>

      <apply|axiomtype|Fraction Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  but we cannot use this to redefine the type of <with|font family|tt|a>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      a : Fraction Polynomial Integer := a
    </input>

    <\output>
      \ 

      \ \ \ You cannot declare a to be of type Fraction Polynomial Integer\ 

      \ \ \ \ \ \ because either the declared type of a or the type of the
      value of

      \ \ \ \ \ \ a is different from Fraction Polynomial Integer .

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  <inactive|><with|font family|tt|Fraction> and <with|font
  family|tt|Polynomial> are examples of <with|font shape|italic|type
  constructors>, which are used in <apply|Language|> to build new types from
  old. <with|font family|tt|Fraction> <with|font shape|italic|type1>
  specifies fractions whose numerator and denominator are of type <with|font
  shape|italic|type1>; <with|font family|tt|Polynomial> <with|font
  shape|italic|type2> specifies polynomials whose coefficients are of type
  <with|font shape|italic|type2>. Another simple type constructor is
  <with|font family|tt|Factored>, which does exactly what its name suggests:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      y := x^2 + 3*x + 2
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|x<rsup|2>+3x+2<apply|leqno>(38)>
      </with>

      <apply|axiomtype|Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      y := y :: Factored Polynomial Integer
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|(>x+1<right|)><left|(>x+2<right|)><apply|leqno>(39)>
      </with>

      <apply|axiomtype|Factored Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  We have also met the type constructors <with|font family|tt|Complex> and
  <with|font family|tt|Equation> and the type <with|font family|tt|Float>.

  As type names can become rather unwieldy, we are permitted to
  abbreviate<apply|index|type!abbreviated names> their components:
  <vspace|5mm>

  <\center>
    <expand|tabular*|<tformat|<cwith|1|-1|1|1|cell
    halign|l>|<cwith|1|-1|2|2|cell halign|l>|<cwith|1|-1|3|3|cell
    halign|l>|<cwith|1|-1|4|4|cell halign|l>|<table|<row|<cell|<with|font
    family|tt|INT> >|<cell|>|<cell| for >|<cell| <with|font
    family|tt|Integer> >>|<row|<cell|<with|font family|tt|NNI>
    >|<cell|>|<cell| for >|<cell| <with|font family|tt|NonNegativeInteger>
    >>|<row|<cell|<with|font family|tt|PI> >|<cell|>|<cell| for >|<cell|
    <with|font family|tt|PositiveInteger> >>|<row|<cell|<with|font
    family|tt|POLY> >|<cell|>|<cell| for >|<cell| <with|font
    family|tt|Polynomial> >>>>> <space|15mm>
    <expand|tabular*|<tformat|<cwith|1|-1|1|1|cell
    halign|l>|<cwith|1|-1|2|2|cell halign|l>|<cwith|1|-1|3|3|cell
    halign|l>|<cwith|1|-1|4|4|cell halign|l>|<table|<row|<cell|<with|font
    family|tt|FRAC> >|<cell|>|<cell| for >|<cell| <with|font
    family|tt|Fraction> >>|<row|<cell|<with|font family|tt|FR>
    >|<cell|>|<cell| for >|<cell| <with|font family|tt|Factored>
    >>|<row|<cell|<with|font family|tt|EQ> >|<cell|>|<cell| for >|<cell|
    <with|font family|tt|Equation> >>|<row|<cell|<with|font family|tt|EXPR>
    >|<cell|>|<cell| for >|<cell| <with|font family|tt|Expression> >>>>>
  </center>

  <vspace|5mm>(For some of the shorter type names the abbreviation is merely
  the same word all in upper case, eg. <with|font family|tt|FLOAT> for
  <with|font family|tt|Float>.)

  If our expressions involve polynomials in more than one variable
  (multivariate polynomials), <apply|Language|> will choose which to treat as
  the ``main variable'', with the others appearing in its coefficients.

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      )clear p y -- since y has a value
    </input>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      P := (y + z)*x^2 + z*x + c
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|(>x<rsup|2>+x<right|)>z+x<rsup|2>y+c<apply|leqno>(40)>
      </with>

      <apply|axiomtype|Polynomial Integer >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Here, <apply|Language|> chose the alphabetically last variable, <with|font
  family|tt|z>, although we carefully input the expression for <with|font
  family|tt|P> as a polynomial in <with|font family|tt|x>.

  We can control the choice of main variable by using the type <with|font
  family|tt|UnivariatePolynomial><apply|index|UnivariatePolynomial@<verbatim|UnivariatePolynomial>>,
  abbreviated to <with|font family|tt|UP>, which takes two parameters, the
  first specifying the variable of choice and the second the type of the
  coefficients. To display <with|font family|tt|P> in the form we chose for
  input, we could try:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      P :: UP(x,POLY INT)
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|(>z+y<right|)>x<rsup|2>+z*x+c<apply|leqno>(41)>
      </with>

      <apply|axiomtype|UnivariatePolynomial(x,Polynomial Integer) >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  which almost gives the form we want. We can, of course, also use <with|font
  family|tt|UnivariatePolynomial> to control the form of the coefficients
  (specifying the ``next most important'' variable and so on):

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      P :: UP(x, UP(y, POLY INT))
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|(>y+z<right|)>x<rsup|2>+z*x+c<apply|leqno>(42)>
      </with>

      <apply|axiomtype|UnivariatePolynomial(x,UnivariatePolynomial(y,Polynomial
      Integer)) >
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  Note that in this example, <with|font family|tt|P> has retained its
  original type as provided by <apply|Language|>; we have, so far, merely
  displayed it in different forms. We could, if we wished, completely specify
  the ordering<apply|index|ordering variables><apply|index|variable!ordering>
  of the variables in <with|font family|tt|P>:

  <with|prog language|axiom|this session|default|<\session>
    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      P := P :: UP(x, UP(y, UP(z, UP(c, INT))))
    </input>

    <\output>
      <\with|mode|math>
        <with|formula style|true|<left|(>y+z<right|)>x<rsup|2>+z*x+c<apply|leqno>(43)>
      </with>

      Type: UnivariatePolynomial(x,UnivariatePolynomial(y,UnivariatePolynomial(z,UnivariatePolynomial(c,Integer))))

      \;
    </output>

    <\input|<\with|color|red>
      <with|mode|math|\<rightarrow\>>\ 
    </with>>
      \;
    </input>
  </session>>

  In practice, if we are interested in the order of the variables in a
  multi-variate polynomial we would use the <apply|Language|> type whose
  first argument is an ordered list of symbols, but we shall not go in to
  such details here.

  Various other useful forms of polynomials are discussed in section 1.9 of
  the <apply|Language|> manual.

  <apply|nextTopic|algebra05.tm> <apply|previousTopic|algebra03.tm>
</body>

<\initial>
  <\collection>
    <associate|paragraph width|150mm>
    <associate|odd page margin|30mm>
    <associate|page right margin|30mm>
    <associate|page top margin|30mm>
    <associate|reduction page right margin|25mm>
    <associate|reduction page bottom margin|15mm>
    <associate|even page margin|30mm>
    <associate|reduction page left margin|25mm>
    <associate|page bottom margin|30mm>
    <associate|reduction page top margin|15mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|idx-1|<tuple|<uninit>|?>>
    <associate|toc-1|<tuple|<uninit>|?>>
    <associate|idx-2|<tuple|<uninit>|?>>
    <associate|idx-3|<tuple|<uninit>|?>>
    <associate|idx-4|<tuple|<uninit>|?>>
    <associate|idx-5|<tuple|<uninit>|?>>
    <associate|idx-6|<tuple|<uninit>|?>>
    <associate|rearrange|<tuple|<uninit>|?>>
    <associate|idx-7|<tuple|<uninit>|?>>
    <associate|idx-8|<tuple|<uninit>|?>>
    <associate|idx-9|<tuple|<uninit>|?>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|idx>
      <tuple|<tuple|::@<with|font family|<quote|tt>|language|<quote|verbatim>|::>>|<pageref|idx-1>>

      <tuple|<tuple|type!conversion>|<pageref|idx-2>>

      <tuple|<tuple|conversion!type>|<pageref|idx-3>>

      <tuple|<tuple|manipulation!type>|<pageref|idx-4>>

      <tuple|<tuple|transformation!type>|<pageref|idx-5>>

      <tuple|<tuple|type!abbreviated names>|<pageref|idx-6>>

      <tuple|<tuple|UnivariatePolynomial@<with|font
      family|<quote|tt>|language|<quote|verbatim>|UnivariatePolynomial>>|<pageref|idx-7>>

      <tuple|<tuple|ordering variables>|<pageref|idx-8>>

      <tuple|<tuple|variable!ordering>|<pageref|idx-9>>
    </associate>
  </collection>
</auxiliary>
