/* Copyright (c) 2002  Michael Stumpf  <mistumpf@de.pepperl-fuchs.com>
   Copyright (c) 2006  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: fixsfsi.S 1487 2007-12-01 02:12:55Z dmix $ */

#include "fp32def.h"
#include "asmdef.h"

/* long __fixsfsi (float A);
     The __fixsfsi() function converts A to the integer value. No rounding,
     the fractional is losted. The compiler calls this function to perform
     a cast operation from float (i.e. double) to long. No saturation.

   Return:
     The integral part of A. If A is too big (i.e. A is less then
     -0x0.ffffffp+31 or A is great then +0x0.ffffffp+31), this realization
     returns the LONG_MIN value (i.e. 0x80000000). If A is not a number,
     also LONG_MIN is returned.

   See '__fixunssfsi.S' why saturation is't used.
 */

ENTRY __fixsfsi
	rcall	_U(__fixunssfsi)
	set
	cpse	rAE, r1			; error flag
	rjmp	_U(__fp_szero)		; return 0x80000000
	ret
ENDFUNC
