/* Copyright (c) 2002, Reiner Patommel
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE. */

/* $Id: atol.S,v 1.7.4.1 2005/11/09 23:54:36 aesok Exp $ */

/*
   atol.S

   Contributors:
     Created by Reiner Patommel
     Modified by Reiner Patommel 8 Feb 2003, Bug #2481
     Modified by Reiner Patommel 13 May 2003, (DOXYGEN)
 */

#include "macros.inc"

#define str_hi		r25
#define str_lo		r24
#define num_hi_hi	r25
#define num_hi_lo	r24
#define num_lo_hi	r23
#define num_lo_lo	r22
#define tmp		r17


/** \ingroup avr_stdlib
    \fn long int atol(const char *string)
    \brief Convert a string to a long integer.

    The atol() function converts the initial portion of the string
    pointed to by \c stringp to integer representation.

    It is equivalent to:

           \code strtol(nptr, (char **)NULL, 10); \endcode
           except that atol() does not detect errors.
*/

#if !defined(DOXYGEN)

	.text
	.global _U(atol)
	.type   _U(atol), @function

/*
   Skip leading spaces and tabs.  Process optional sign.  Stop conversion
   on detection of a non-numeric character.  Return 0 if string contains
   no numeric characters.
 */

_U(atol):
	PUSH	r17
	X_movw	ZL, str_lo		; set pointer to string
	CLR	num_hi_hi
	CLR	num_hi_lo
	CLR	num_lo_hi
	CLR	num_lo_lo		; clear number
	CLT				; clear sign

.L_atol_loop:
	LD	tmp, Z+			; get (next) character
	TST	tmp			; is it end of string?
	BREQ	.L_atol_sig
	CPI	tmp, ' '		; skip whitespace
	BREQ	.L_atol_loop
	CPI	tmp, '\t'
	BREQ	.L_atol_loop
	CPI	tmp, '\n'
	BREQ	.L_atol_loop
	CPI	tmp, '\f'
	BREQ	.L_atol_loop
	CPI	tmp, '\r'
	BREQ	.L_atol_loop
	CPI	tmp, '\v'
	BREQ	.L_atol_loop
	CPI	tmp, '+'		; if '+' go on
	BREQ	.L_atol_loop2
	CPI	tmp, '-'		; if '-' remember sign
	BRNE	.L_atol_digit

.L_atol_neg:
	SET				; remember number is negative

.L_atol_loop2:
	LD	tmp, Z+
	TST	tmp
	BREQ	.L_atol_sig

.L_atol_digit:
	CPI	tmp, '0'		; test on [0 .. 9]
	BRLT	.L_atol_sig
	CPI	tmp, '9'+1
	BRGE	.L_atol_sig
	SUBI	tmp, '0'		; make figure a number
	XCALL	__mulsi_const_10	; r25:r24:r23:r22 *= 10
	ADD	num_lo_lo, tmp		; num = (num * 10) + (tmp - '0')
	ADC	num_lo_hi, __zero_reg__
	ADC	num_hi_lo, __zero_reg__
	ADC	num_hi_hi, __zero_reg__
	RJMP	.L_atol_loop2		; next figure

.L_atol_sig:
	CP	num_lo_lo, __zero_reg__
	CPC	num_lo_hi, __zero_reg__
	CPC	num_hi_lo, __zero_reg__
	CPC	num_hi_hi, __zero_reg__	; did we get a number?
	BREQ	.L_atol_done		; no, drop sign and return
	BRTC	.L_atol_done		; positive number? -> return
	COM	num_hi_hi
	COM	num_hi_lo
	COM	num_lo_hi
	NEG	num_lo_lo
	SBCI	num_lo_hi, 0xff
	SBCI	num_hi_lo, 0xff
	SBCI	num_hi_hi, 0xff		; make number negative

.L_atol_done:
	POP	r17
	RET

.L_atol_end:
	.size _U(atol), .L_atol_end - _U(atol)

#endif /* not DOXYGEN */
