/* Copyright (c) 2002, Reiner Patommel
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE. */

/* $Id: strcasecmp_P.S,v 1.4.4.1 2005/11/08 16:21:01 aesok Exp $ */

/*
   strcasecmp_P.S
   Case insensitive compare

   Contributors:
     Created by Reiner Patommel
*/
#include "macros.inc"

#define s1_hi r25
#define s1_lo r24
#define s2_hi r23
#define s2_lo r22

#define ret_hi r25
#define ret_lo r24

#define tmp r22
#define cht r21

/** \ingroup avr_pgmspace
    \fn int strcasecmp_P(const char *s1, PGM_P s2)
    \brief Compare two strings ignoring case.

    The strcasecmp_P() function compares the two strings s1 and s2, ignoring
    the case of the characters.

    \param s1 A pointer to a string in the devices SRAM.
    \param s2 A pointer to a string in the devices Flash.

    \returns The strcasecmp_P() function returns an integer less than, equal
    to, or greater than zero if s1 is found, respectively, to be less than, to
    match, or be greater than s2.  */

#if !defined(DOXYGEN)

	.text
	.global	_U(strcasecmp_P)
	.type	_U(strcasecmp_P), @function
_U(strcasecmp_P):
	X_movw	ZL, s2_lo
	X_movw	XL, s1_lo
.L_strcasecmp_P_loop:
	LD	ret_lo, X+		; load *s1
	LPM_R0_ZP			; load *s2
	MOV	tmp,r0			; copy of *s2 to tmp
	MOV	cht, r0			; copy of *s2 to cht
	ORI	cht, 0x20		; make tmp lower case
	CPI	cht, 'a'		; test on [a .. z]
	BRLT	.L_strcasecmp_P_tst
	CPI	cht, 'z'+1
	BRGE	.L_strcasecmp_P_tst
	ORI	tmp, 0x20		; we got an aplpha in s2
	ORI	ret_lo, 0x20
.L_strcasecmp_P_tst:			; compare
	SUB	ret_lo, tmp
	BRNE	.L_strcasecmp_P_done
	TST	r0			; end of s2?
	BRNE	.L_strcasecmp_P_loop
.L_strcasecmp_P_done:
; ret_hi = SREG.C ? 0xFF : 0
	SBC	ret_hi, ret_hi
	RET
.L_strcasecmp_P_end:
	.size   _U(strcasecmp_P), .L_strcasecmp_P_end - _U(strcasecmp_P)

#endif /* not DOXYGEN */
