/* AVLDB - AVL DataBase library, brute force debugging support

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#define  __ADB 1
#include "adb.h"


#define BASE "/u/tmp/tex"

static int texc = 0 ;

int Adb_tex(adb_tnx_t *tnx, adb_file_t *file, adb_bh_t *bh);

void
Adb_tex_show(adb_rec_t *rec, adb_file_t *file, FILE *FP)
{
  int i ;
  adb_field_t *fld ;
  int *p_int ;
  char *p_char ;
  long long *p_ll ;
  unsigned long long *p_ull ;
  long double *p_d ;
  adb_vstring_t *vs ;
  void *data = rec ;

  assert( file->magic == ADB_MAGIC_FILE );
  /* Ranges carry magic stuff too */
  assert( rec->magic == ADB_MAGIC_RECORD );

  for ( i = 0 ; i < file->meta->idx_size ; ++i )
    {
      if ( (void *)file->idx[i] + file->db->addr )
	{
	  fld = (void *)file->idx[i] + file->db->addr ;
	  if ( fld->magic == ADB_MAGIC_FIELD )
	    {
#if 0
	      fprintf(FP,"[%s] ",fld->name );
#endif
	      switch (  fld->type )
		{
		case ADB_FIELD_INT:
		  p_int =  (void *)data + fld->offset ;
		  fprintf(FP,"%d,", *p_int );
/* 		  assert ( *p_int < 10001000 && *p_int >= 0); */ /* ET value 26361856 */
		  break ;
		case ADB_FIELD_STRING:
		  p_char = (void *)data + fld->offset ;
/* 		  fprintf(FP,"%s ", p_char ); */
		  while ( *p_char )
		    {
		      switch ( *p_char )
			{
			case '\\':
			  fputs("/BS/", FP);
			  break ;
			default:
			  fputc(*p_char, FP);
			  break ;
			}
		      ++p_char ;
		    }
		  fputc(' ', FP);
		  break ;
		case ADB_FIELD_VSTRING:
		  vs = (void *)data + fld->offset ;
		  p_char = (void *) vs + vs->offset ;
		  fprintf(FP,"%5.5s", /* vs->size, vs->offset, */ p_char );
		  break ;
		case ADB_FIELD_WCHAR:
		  {
		    adb_wchar_t *wc = (void *)data + fld->offset ;
		    wchar_t *s = (void *)data + wc->offset + fld->offset ;
		    fprintf(FP, "%5.5ls", s);
		  }
		  break ;
		case ADB_FIELD_LONG_LONG:
		  p_ll = (void *)data + fld->offset ;
		  fprintf(FP,"%lld ", *p_ll );
		  break ;
		case ADB_FIELD_UNSIGNED_LONG_LONG:
		  p_ull = (void *)data + fld->offset ;
		  fprintf(FP,"%llu ", *p_ull );
		  break ;
		case ADB_FIELD_DOUBLE:
		  p_d = (void *)data + fld->offset ;
		  fprintf(FP, "%Lf ", *p_d );
		  break ;
		default:
		  assert("FIXME" == 0);
		  break ;
		}
	      if ( i >= 3 )
		return ; /* show only one field */
	    }
	}
    }
/*   fputc('\n',FP); */
}

void
Adb_tex_dump(adb_range_t *range, adb_tnx_t *tnx, adb_file_t *file, 
	       adb_bh_t *bh UNUSED , FILE *FP)
{
  adb_rec_t *rec = NULL ;
  adb_bh_t *child ;
  int i = EOF ;
  switch ( range->magic )
    {
    case ADB_MAGIC_RECORD:
      rec = (adb_rec_t *)range ;
      break ;
    case ADB_MAGIC_RANGE:
      rec = adb_range_to_rec(range);
      /* dump whatever is below */
      child = Adb_seg_load( tnx, file, range->offset, ADB_TNX_NULL);

      i = Adb_tex(tnx, file, child);
      break ;
    default:
      assert("huh?" == 0 );
      break ;
    }
  Adb_tex_show( rec, file, FP) ;
  if ( i != EOF )
    fprintf(FP, "i%d r%d",i,range->id);
}
#if 0
void
Adb_tex_node(adb_tavl_node_t *node, int c , adb_tnx_t *tnx, adb_file_t *file,
	       adb_bh_t *bh, FILE *FP )
{
  adb_range_t *r ;
  r = DATA(node);
  if ( node->tavl_tag[0] != TAVL_CHILD && node->tavl_tag[1] != TAVL_CHILD )
    {
      fputs("\\leaf{",FP);
      Adb_tex_dump(r, tnx, file, bh, FP);
      fputs("}\n",FP);
      return ;
    }
  if ( node->tavl_tag[0] == TAVL_CHILD && node->tavl_tag[1] == TAVL_CHILD )
    {
      fputs("\\branch2{",FP);
      Adb_tex_dump(r, file, bh, FP);
      fprintf(FP,"} %d:%d,%d.\n", c , c * 100 + 1  , c * 10000 + 2);
      Adb_tex_node( (void *) node->tavl_link[0] + bh->addr ,
		      c * 100 + 1 , tnx, file, bh, FP);
      Adb_tex_node( (void *) node->tavl_link[1] + bh->addr,
		      c * 10000 + 2 , tnx, file, bh, FP);
      return ;
    }
  if ( node->tavl_tag[0] == TAVL_CHILD )
    {
     fputs("\\branch2{",FP);
      Adb_tex_dump(r, file, bh, FP);
      fprintf(FP,"} %d:%d.\n", c , c + 1);
      Adb_tex_node( (void *) node->tavl_link[0] + bh->addr ,
		      c + 1 , tnx, file, bh, FP);
      return ;
    }

  if ( node->tavl_tag[1] == TAVL_CHILD )
    {
     fputs("\\branch2{",FP);
      Adb_tex_dump(r, file, bh, FP);
      fprintf(FP,"} %d:%d.\n", c , c + 2);
      Adb_tex_node( (void *) node->tavl_link[1] + bh->addr ,
		      c + 2 , tnx, file, bh, FP);
      return ;
    }
}
#endif /* 0 */

int
Adb_tex_get_level(unsigned int sb , const adb_tavl_table_t *tree, adb_tavl_node_t *node)
{
  int level  ;
  adb_tavl_node_t *root = (void *)tree->tavl_root + sb , *parent , *n = node ;
  if ( node == root )
    return 0 ;

  for ( level = 1 ; ; ++level )
    {
      parent = adb_find_parent(sb, (adb_tavl_table_t *) tree, n );
      if ( parent == root )
	return level ;
      n = parent ;
    }
}

void
Adb_tex_bh(adb_tnx_t *tnx,  adb_file_t *file , adb_bh_t *bh, FILE *FP)
{
  int count = adb_tavl_count(&bh->m->tree);
  float hf = 1.44 * log2f( count + 2 ) - 0.328 ; /* 1.44 lg (N + 2) - .328 */
  int h = ceil(hf);

  int level = 0 ;
  const adb_tavl_table_t *tree = &bh->m->tree ;
  adb_tavl_node_t *n ;
  const unsigned int sb = bh->addr ;
  const void *null = (void *)sb ;
  int i , l , max = 0 ;

  FILE *TMP[h] ;

  size_t len = 0 ;
  char *line = NULL ;
  ssize_t size ;
  
  char *box[h] ; /* [ count*2 + 10] ; */

  for ( i = 0 ; i < h ; ++i )
    box[i] = malloc(count*2 + 10);

  n = (void *)tree->tavl_root + sb;
  /* phase 1: fill matrix */
  while ( n->tavl_tag[0] == TAVL_CHILD)
    {
      n = (void *)n->tavl_link[0] + sb ;
      ++level ;
    }
  
  for ( max = 0 , i = 0 ; ; i += 2  )
    {
      if ( level > max )
	max = level ;

      for ( l = 0 ; l < h ; ++l )
	{
	  if ( l == level )
	    box[l][i] = '*' ;
	  else
	    box[l][i] = ' ' ;
	  box[l][i+1] = '&' ;
	}
      
      
      if (n->tavl_tag[1] == TAVL_THREAD)
	{
	  n = (void *)n->tavl_link[1] + sb ;
	}
      else
	{
	  n = (void *)n->tavl_link[1] + sb;
	  while (n->tavl_tag[0] == TAVL_CHILD)
	    n = (void *)n->tavl_link[0] + sb ;
	}
      if ( n == null )
	{
	  for ( l = 0 ; l < h ; ++l )
	    box[l][i+2] = 0 ;
	  break ;
	}
      level = Adb_tex_get_level(sb, tree, n );
    }

  for ( i = 0 ; i <= max ; ++i )
    {
      int ii ;
      fprintf(stderr,"MATRIX [%d]: ",i);
      for ( ii = 0 ; box[i][ii] ; ++ii )
	fputc(box[i][ii], stderr);
      fputc('\n',stderr);
    }

  /* step 2: write out those stuff, which makes LaTeX mad ( me too ) */

  for ( i = 0 ; i <= max ; ++i )
    TMP[i] = tmpfile() ;
  /* walk thru tree */
  n = (void *)tree->tavl_root + sb;
  for ( level = 0 ; n->tavl_tag[0] == TAVL_CHILD ; )
    {
      n = (void *)n->tavl_link[0] + sb ;
      ++level ;
    }

  for ( i = 0 ; ; i += 2 )
    {
      for ( l = 0 ; l <= max ; ++l )
	{
	  if ( l == level )
	    {
	      int left = 0 , right = 0 , j ;
	      char *p , *q = &box[level+1][i] ;
	      /* left child */
	      if ( n->tavl_tag[0] == TAVL_CHILD)
		{
		  for ( p = &box[level+1][i] ; ; --p )
		    if ( *p == '*' )
		      {
			left = ( q - p ) / 2 ;
			break ;
		      }
		}
	      /* right child */
	      if ( n->tavl_tag[1] == TAVL_CHILD)
		{
		  for ( p = &box[level+1][i] ; ; ++p )
		    if ( *p == '*' )
		      {
			right = ( p - q ) / 2 ;
			break ;
		      }
		}
	      if ( left )
		{
		  fputs("\\ar[d", TMP[l] );
		  for ( j = 0 ; j < left ; ++j )
		    fputc('l', TMP[l]);
		  fputs("] ", TMP[l]);
		}
	      Adb_tex_dump( DATA(n), tnx, file, bh, TMP[l] );

	      if ( right )
		{
		  fputs("\\ar[d", TMP[l] );
		  for ( j = 0 ; j < right ; ++j )
		    fputc('r', TMP[l]);
		  fputs("] ", TMP[l]); 
		}
	      fputs(" & ", TMP[l]);
	    }
	  else
	    fputs(" & ", TMP[l]);
	}

      if (n->tavl_tag[1] == TAVL_THREAD)
	{
	  n = (void *)n->tavl_link[1] + sb ;
	}
      else
	{
	  n = (void *)n->tavl_link[1] + sb;
	  while (n->tavl_tag[0] == TAVL_CHILD)
	    n = (void *)n->tavl_link[0] + sb ;
	}
      if ( n == null )
	{
	  for ( l = 0 ; l <= max ; ++l )
	    {
	      fflush(TMP[l]);
	      fseek(TMP[l], 0, SEEK_SET);
	    }
	  break ;
	}
      level = Adb_tex_get_level(sb, tree, n );
    }
  
  /* step 3: merge nasty craps together */
  for ( l = 0 ; l <= max ; )
    {
      if ( (size = getline(&line,&len,TMP[l])) == EOF )
	{
	  fclose(TMP[l]);
	  fputs(" \\\\\n",FP);
	  ++l ; 
	}
      else
	fputs( line, FP );
    }
}

int
Adb_tex(adb_tnx_t *tnx, adb_file_t *file, adb_bh_t *bh)
{
  FILE *FP ;
  char *name = NULL , *cmd = NULL ;
  int rv = ++texc ;
/*   adb_tavl_table_t *tree = &bh->m->tree ; */

  asprintf(&name, "%d.tex", rv );
  if ( ( FP = fopen(name,"w")) == NULL )
    {
      ADB_ERROR("Fopen %s",name);
      return EOF ;
    }
  fputs("% created by prophet\n"
	"\\input xy\n"
	"\\xyoption{all}\n"
	"\\documentclass[a3paper,oneside,onecolumn]{book}\n"
	"%\\usepackage{epsfig,graphicx,fancyhdr,lastpage,geometry}\n"
	"%\\usepackage{geometry}\n"
	"%\\usepackage[]{fontenc}\n"
	"%\\usepackage[latin2]{inputenc}\n"
	"%\\usepackage{babel}\n"
	"%\\usepackage{times}\n"
	"%\\usepackage{changebar}\n"
	"%\\usepackage{pstricks}\n"
	"%\\usepackage{afterpage}\n"
	"%\\usepackage{longtable}\n"
	"\\usepackage{xy}\n"
	"\\usepackage{landscape}\n"
	"\\special{landscape}\n"
	"\\batchmode\n"
	"%\\pagestyle{fancy}\n"
	"\\begin{document}\n"
	"\\newcommand{\\tbsp}{\\rule{0pt}{18pt}}\n"
	"% LMF - preamble end\n"
	"%\\pagenumbering{arabic}\n"
	"\\raggedright\n",
	FP );

  switch ( bh->m->content )
    {
    case ADB_MAGIC_RANGE:
      fprintf(FP,"\\huge{Range tree level %d}\n",bh->m->level);
      break ;
    case ADB_MAGIC_TREE:
      fputs("\\huge{Data tree}\n",FP);
      break ;
    default:
      assert("Bug" == 0 );
      break ;
    }
  fputs("\\tiny\n\\xymatrixcolsep{0mm}\n\\xymatrix{\n",FP );

  Adb_tex_bh(tnx, file , bh, FP);

  fputs("}\n\\end{document}\n", FP) ;
  fclose(FP);

  asprintf(&cmd,"latex %s >& /dev/null",name);
  system(cmd);

  free(cmd);  cmd = NULL ;

  asprintf(&cmd,"dvips -t a3 %d.dvi -o %d.ps >& /dev/null", rv , rv);
  system(cmd);

  free(name);

  free(cmd);

  return rv ;
}

void
adb_tex(adb_tnx_t *tnx, adb_file_t *file, char *dir)
{
  adb_bh_t *bh ;
  static int seq ;
  char *seq_dir = NULL ;
  /* root block */
  bh = Adb_seg_load( tnx, file, file->meta->data_start, ADB_TNX_NULL);
  chdir(BASE);
  mkdir(dir, 0777);
  chdir(dir);

  asprintf(&seq_dir, "%d", seq++ );
  mkdir(seq_dir, 0777 );
  chdir(seq_dir);

  texc = 0 ;
  Adb_tex(tnx, file, bh );
}
