/* AVLDB - AVL DataBase library, DB dump

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/
#define  __ADB 1
#include "adb.h"


static FILE *DUMP ;

void
Adb_dump(void *data, void *param )
{
  adb_rec_t *rec = (adb_rec_t *) data ;
  adb_walk_t *w = (adb_walk_t *) param ;
  adb_file_t *file = (adb_file_t *) w->file ;

  int i ;
  adb_field_t *fld ;
/*   int *p_int ; */
/*   char *p_char ; */
/*   long long *p_ll ; */
/*   long double *p_d ; */
  void *v ;
  unsigned int sb = file->db->addr ;

  assert( file->magic == ADB_MAGIC_FILE );
  /* Ranges carry magic stuff too */
  assert( rec->magic == ADB_MAGIC_RECORD );
  
  for ( i = 0 ; i < file->meta->last_order ; ++i )
    {
      if ( (void *)file->order[i] + sb )
	{
	  fld = (void *)file->order[i] + sb  ;
	  if ( fld->magic == ADB_MAGIC_FIELD )
	    {
/* 	      fprintf(stderr,"[%s] ",fld->name ); */
	      switch (  fld->type )
		{
		case ADB_FIELD_INT:
		  v = data + fld->offset ;
		  fprintf(DUMP,"%10d,", *(int *)v );
		  break ;
		case ADB_FIELD_STRING:
		  {
		    char *p ;
		    p = (void *)data + fld->offset ;
		    for ( ; *p ; ++p )
		      {
			switch (*p)
			  {
			  case '"':
			  case '\n':
			  case ',':
			    fputc('\\',DUMP);
			    break ;
			  }
			fputc(*p, DUMP);
		      }
		    fputc(',', DUMP);
		    /* 		  fprintf(stderr,"{%s} ", p_char ); */
		  }
		  break ;
		case ADB_FIELD_LONG_LONG:
		  v = (void *)data + fld->offset ;
		  fprintf(stderr,"{%lld} ", *(long long*)v );
		  break ;
		case ADB_FIELD_UNSIGNED_LONG_LONG:
		  v = (void *)data + fld->offset ;
		  fprintf(stderr,"{%llu} ", *(unsigned long long*)v );
		  break ;
		case ADB_FIELD_DOUBLE:
		  v = (void *)data + fld->offset ;
		  fprintf(stderr, "{%Lf} ", *(long double *)v );
		  break ;
		default:
		  assert("FIXME" == 0);
		  break ;
		}
	    }
	    }
    }
  fputc('\n',DUMP);
}



void
adb_dump(adb_db_t *db, char *filename, char *dumpfile)
{
  adb_tnx_t *tnx = adb_tnx_new();
  adb_file_t *file ;

  if ( dumpfile == NULL )
    dumpfile = filename ;

  if ( ( DUMP = fopen(dumpfile, "w") ) == NULL )
    {
      g_warning("Can't open `%s'" , dumpfile );
      return ;
    }

  file = adb_file_open(db, filename);
  assert(file);
  
  adb_walk( tnx, file, Adb_dump , NULL );

  adb_tnx_end(&tnx);	    
  fclose(DUMP);
  return ;
}
#if 0
void
adb_dump_all()
{
  avlt_walk ( adb_sb->files, __file_cmp,  _adb_show_file , NULL );
}
#endif
