#define CMP_TYPE(type, name, out) \
int \
Adb__cmp_ ## name (const void *ap , const void *bp) \
{ \
  type a = (*(type *) ap) ; \
  type b = (*(type *) bp) ; \
\
  if (  Adb_debug & ADB_DEBUG_RANGE_CMP )\
    fprintf(stderr, "%s: a: " out " b: " out " return %d\n",  \
	    __func__, a, b, ( a > b ) - ( a < b )) ;\
\
  return ( a > b ) - ( a < b ) ; \
} \

#define MATCH_TYPE(type, name) \
int \
Adb__match_ ## name (const void *ap , const void *lp, const void *rp) \
{ \
  type a = (*(type *) ap) ; \
  type l = (*(type *) lp) ; \
  type r = (*(type *) rp) ; \
  return ( a > l &&  a < r ) ; \
} \



CMP_TYPE(unsigned int, uint, "%u")

CMP_TYPE(int, int, "%d")

CMP_TYPE(long long, ll, "%lld")

CMP_TYPE(unsigned long long, ull, "%llu")

CMP_TYPE(long double, ld, "%Lg")

CMP_TYPE(ptrdiff_t, ptr, "%d")

MATCH_TYPE(unsigned int, uint)

MATCH_TYPE(int, int )

MATCH_TYPE(long long, ll)

MATCH_TYPE(unsigned long long, ull)

MATCH_TYPE(long double, ld)

MATCH_TYPE(ptrdiff_t, ptr)
