/* AVLDB - AVL DataBase library, tavl functions for "relative" address space

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>
   
   Based on Ben Pfaff's libavl tavl.h with dizzy modifications
   to fit for my silly needs. Original copyright follows.
*/

/* Produced by texiweb from libavl.w on 2002/03/14 at 12:47. */

/* libavl - library for manipulation of binary trees.
   Copyright (C) 1998-2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

   The author may be contacted at <blp@gnu.org> on the Internet, or
   as Ben Pfaff, 12167 Airport Rd, DeWitt MI 48820, USA through more
   mundane means.
*/

#ifndef ADB_TAVL_H
#define ADB_TAVL_H 1

#include <stddef.h>

/* Function types. */
typedef int adb_tavl_comparison_func (const void *tavl_a, const void *tavl_b,
                                 void *tavl_param);
typedef void adb_tavl_item_func (void *tavl_item, void *tavl_param);
typedef void *adb_tavl_copy_func (void *tavl_item, void *tavl_param);
typedef void adb_tavl_walk_func_t (const adb_bh_t *, const void *, const void *)  ;

#ifndef LIBAVL_ALLOCATOR
#define LIBAVL_ALLOCATOR
/* Memory allocator. */
struct adb_libavl_allocator
  {
    void *(*libavl_malloc) (struct adb_libavl_allocator *, size_t libavl_size);
    void (*libavl_free) (struct adb_libavl_allocator *, void *libavl_block);
  };
#endif

/* Default memory allocator. */
extern struct adb_libavl_allocator adb_tavl_allocator_default;
void *adb_tavl_malloc (struct adb_libavl_allocator *, size_t);
void adb_tavl_free (struct adb_libavl_allocator *, void *);

/* Maximum TAVL height. */
#ifndef TAVL_MAX_HEIGHT
#define TAVL_MAX_HEIGHT 32
#endif

/* Tree data structure. */
struct adb_tavl_table
  {
    struct adb_tavl_node *tavl_root;        /* Tree's root. */
/*     tavl_comparison_func *tavl_compare; */ /* Comparison function. */
/*     void *tavl_param;                  */  /* Extra argument to |tavl_compare|. */
/*     struct libavl_allocator *tavl_alloc; */ /* Memory allocator. */
    size_t tavl_count;                  /* Number of items in tree. */
} ;

/* Characterizes a link as a child pointer or a thread. */
typedef enum adb_tavl_tag
  {
    TAVL_CHILD = 2 ,                     /* Child pointer. */
    TAVL_THREAD = 1,                    /* Thread. */
  } adb_tavl_tag_t ;

/* An TAVL tree node. */
struct adb_tavl_node
{
  struct adb_tavl_node *tavl_link[2]; /* Subtrees. */
  /*   void *tavl_data; */                /* Pointer to data. */
  adb_tavl_tag_t tavl_tag[2];      /* Tag fields. */
  signed char tavl_balance;       /* Balance factor. */
}  ;

/* TAVL traverser structure. */
struct adb_tavl_traverser
{
  struct adb_tavl_table *tavl_table;        /* Tree being traversed. */
  struct adb_tavl_node *tavl_node;          /* Current node in tree. */
} ;

typedef struct adb_tavl_table adb_tavl_table_t ;
typedef struct adb_tavl_node adb_tavl_node_t ;
typedef struct adb_tavl_traverser adb_tavl_traverser_t ;



/* Table functions. */
struct adb_tavl_table *adb_tavl_create (adb_tavl_table_t * const tree);
/* struct tavl_table *tavl_copy (const struct tavl_table *, tavl_copy_func *, */
/*                             tavl_item_func *, struct libavl_allocator *); */
void adb_tavl_destroy (adb_bh_t *, adb_tavl_item_func *, void *);
void *adb_tavl_probe (const adb_bh_t *, adb_tavl_node_t *, void *);
void *adb_tavl_insert (const adb_bh_t *, adb_tavl_node_t *, void *);
void *adb_tavl_replace (adb_bh_t *, adb_tavl_node_t *, void *);
const void *adb_tavl_delete (const adb_bh_t *, const void *);
void *adb_tavl_find (const adb_bh_t *, const void *);
void *adb_tavl_find_close (const adb_bh_t *ta, const void *item);
void adb_tavl_assert_insert (adb_bh_t *, adb_tavl_node_t * , void *);
const void *adb_tavl_assert_delete (adb_bh_t *, void *);

#define adb_tavl_count(table) ((size_t) (table)->tavl_count)


/* Table traverser functions. */
void adb_tavl_t_init (const adb_bh_t *,struct adb_tavl_traverser *);
void *adb_tavl_t_first (const adb_bh_t *,struct adb_tavl_traverser *);
void *adb_tavl_t_last (const adb_bh_t *,struct adb_tavl_traverser *);
void *adb_tavl_t_find (const adb_bh_t *,struct adb_tavl_traverser *,  void *);
void *adb_tavl_t_find_close (const adb_bh_t *ta, struct adb_tavl_traverser *trav, void *item);
void *adb_tavl_t_insert (const adb_bh_t *,struct adb_tavl_traverser *,adb_tavl_node_t *,void *);
void *adb_tavl_t_copy (const adb_bh_t *,struct adb_tavl_traverser *, const struct adb_tavl_traverser *);
void *adb_tavl_t_next (const adb_bh_t *,struct adb_tavl_traverser *);
void *adb_tavl_t_prev (const adb_bh_t *,struct adb_tavl_traverser *);
void *adb_tavl_t_cur (const adb_bh_t *,struct adb_tavl_traverser *);
void *adb_tavl_t_replace (const adb_bh_t *,struct adb_tavl_traverser *, void *);
void adb_tavl_walk (const adb_bh_t *ta, void (*func)(), void *param);

struct adb_tavl_node *adb_find_parent (unsigned int sb , struct adb_tavl_table *tree, struct adb_tavl_node *node);

#endif /* tavl.h */
