/* AVLDB - AVL DataBase library, main .h


   Copyright (C) 2002,2003,2004 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

/* BEGIN_C_DECLS should be used at the beginning of your declarations,
   so that C++ compilers don't mangle their names.  Use END_C_DECLS at
   the end of C declarations. */
#undef BEGIN_C_DECLS
#undef END_C_DECLS
#ifdef __cplusplus
# define BEGIN_C_DECLS extern "C" {
# define END_C_DECLS }
#else
# define BEGIN_C_DECLS /* empty */
# define END_C_DECLS /* empty */
#endif
     
/* PARAMS is a macro used to wrap function prototypes, so that
   compilers that don't understand ANSI C prototypes still work,
   and ANSI C compilers can issue warnings about type mismatches. */
#undef PARAMS
#if defined (__STDC__) || defined (_AIX) \
             || (defined (__mips) && defined (_SYSTYPE_SVR4)) \
             || defined(WIN32) || defined(__cplusplus)
# define PARAMS(protos) protos
#else
# define PARAMS(protos) ()
#endif

#ifndef _ADB_H
#define _ADB_H 1

#define USE_FTRUNCATE

#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stddef.h>
#include <fcntl.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <getopt.h>
#include <time.h>
#include <errno.h>
#include <sys/mman.h>
#include <assert.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/wait.h>
#include <argp.h>
#include <glob.h>
#include <setjmp.h>
#include <math.h>
#include <locale.h>
#include <wchar.h>
#include <langinfo.h>
#include <iconv.h>
#include <glib.h>
#include <zlib.h>

/* typedef unsigned char byte_t ; */
#define UNUSED  __attribute__ ((__unused__))

#define HAVE_XMALLOC
#define xmalloc(size) (void *)__adb_malloc(size, adb_mm , __FUNCTION__ )

BEGIN_C_DECLS

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif /* ! TRUE */


/*****************************************************************************/
/*                                                                           */
/*          Each stored pointer MUST be relative                             */
/*                                                                           */
/*****************************************************************************/

#define ADB_SB_SIZE 4096 /* 0x1000 */
#define ADB_SB_BASE ((void *)  0x30000000)
#define ADB_META_SIZE 0x1000000 /* 16MB */
#define ADB_META_MAP_SIZE 0x10000
#define ADB_META_MAGIC_SIZE 0x1000
#define ADB_MAGIC_SIZE ADB_META_MAGIC_SIZE
#define ADB_META_SB_SIZE ( ADB_META_MAP_SIZE + ADB_META_MAGIC_SIZE )
#define ADB_ALL_META_SIZE ( ADB_SB_SIZE + ADB_META_SIZE + ADB_META_SB_SIZE )
#define ADB_SEG_SIZE ( 1048576 + 0x2000 )
#define ADB_SEG_MAP_SIZE 0x1000
#define ADB_SEG_MAGIC_SIZE 0x1000 /* includes ADB_SEG_TREE_PARAM */
#define ADB_SEG_TREE_PARAM 0x800 /* max size 2k */
#define ADB_DATA_MAP_SIZE 0x100000
#define ADB_DATA_MAP_BASE 0x31012000

#define ADB_LOCK_SHM ((char *)0x2FC00000) /* ADB_SB_BASE - 4M */
#define ADB_PTS_SHM  ((char *)0x2FB00000) /* ADB_SB_BASE - 5M */

typedef enum
  {
    ADB_MAGIC_SB       = 0xaeae00 ,
    ADB_MAGIC_META     = 0xaeae01 ,
    ADB_MAGIC_RANGE    = 0xaeae02 ,
    ADB_MAGIC_TREE     = 0xaeae03 ,
    ADB_MAGIC_DATA     = 0xaeae04 , /* data seg id */
    ADB_MAGIC_MM       = 0xaeae05 ,
    ADB_MAGIC_FILE     = 0xaeae06 ,
    ADB_MAGIC_DB       = 0xaeae07 , /* god bless the database */
    ADB_MAGIC_FIELD    = 0xaeae08 ,
    ADB_MAGIC_RECORD   = 0xaeae09 , /* holy record himself */
    ADB_MAGIC_TNX      = 0xaeae0a , /* transaction */
    ADB_MAGIC_BH       = 0xaeae0b , /* TNX block header */
    ADB_MAGIC_TNX_AI   = 0xaeae0c , /* header for AI file */
    ADB_MAGIC_TNX_BI   = 0xaeae0d , /* header for BI file */
    ADB_MAGIC_LINK     = 0xaeae0e , 
/*     ADB_MAGIC_CONTAINER = ADB_MAGIC_LINK, */
    ADB_MAGIC_META_FILE = 0xaeae0f ,
    ADB_MAGIC_BLOB     = 0xaeae10 , 
    ADB_MAGIC_FTS      = 0xaeae11 , /* File To Segment mapping */
    ADB_MAGIC_VSTRING  = 0xaeae12 , 
    ADB_MAGIC_REF      = 0xaeae13 ,
    ADB_MAGIC_DIFF     = 0xaeae14 ,
    ADB_MAGIC_XI_HDR   = 0xaeae15 ,
    ADB_MAGIC_TNX_BIP  = 0xaeaea0 , /* Node of tnx->bis */
    ADB_MAGIC_WCHAR    = 0xaeaea1 , /* unicode string */
  } adb_magic_t ;

#define ADB_MM_MIN 32
#define ADB_MM_SEG 256 /* max one byte length */

typedef enum
  {
    ADB_MODE_SINGLE =  0x1 ,
    ADB_MODE_MULTI  =  0x2 ,
    ADB_MODE_XXX_LOCK   =  0x4 , /* MULTI => LOCK */
    ADB_MODE_BI     =  0x8 ,
    ADB_MODE_AI     = 0x10 ,
  } adb_mode_t ;
#define ADB_MODE_BIT_MAX 5


#ifdef MAIN
char *_adb_mode_list[] =
  {
    "Single user",
    "Multi user",
    "Locking", 
    "Before-imaging"
    "After-imaging",
    NULL
  } ;
#else
extern char *_adb_mode_list[] ;
#endif /* MAIN */

typedef struct ADB_BH adb_bh_t ;

typedef struct ADB_DB adb_db_t ;

/* API */

#include "adb_tavl.h"
#include "tavl.h"
/* #include "meta_tavl.h" */

typedef enum
  {
    ADB_TNX_NULL   = 0x0,
    ADB_TNX_HEAVY  = 0x1, /* save stuff in .bi */
#ifdef  __ADB
    ADB_TNX_DIRTY  = 0x2, /* need sync , this flag is userful only for TAs,
			     not for TNXs !!! */
#endif /*  __ADB */
  } adb_tnx_state_t ;

typedef unsigned int adb_tnx_id_t ;

struct ADB_RECORD
{
  adb_magic_t magic ;
  struct adb_tavl_node node ; 
} ;

typedef struct ADB_RECORD  adb_rec_t ; 

typedef enum 
  {
    ADB_BLOB_FLAG_FP = 0x1,
    ADB_BLOB_FLAG_FD,
    ADB_BLOB_FLAG_NAME ,
  } adb_blob_flag_t ;

struct ADB_BLOB
{
  adb_magic_t magic ;
  adb_blob_flag_t flag ; /* type of arg */
  union 
  {
    FILE *FP ;
    char *name ;
    int fd ;
  } arg ;
  off_t offset ; /* ptr to blob */
  size_t size ;
} ;
typedef struct ADB_BLOB  adb_blob_t ;

#define ADB_REC_DATA_START(p) ( p + sizeof(adb_magic) + sizeof(int) )

struct ADB_MM
{
  adb_magic_t magic ;
  size_t size ;
  size_t map_size ;
  adb_tavl_table_t tree ; /* NOT *tree to avoid malloc */
  adb_magic_t content ; /* TREE / RANGE */
  int level ; /* level >= 1 - RANGE , 0 tree */
  off_t parent ; /* parent block */
};
typedef struct ADB_MM  adb_mm_t ;

#define ADB_NAME_MAX 32
#define ADB_RANGE_LEVEL_MAX 32

#define ADB_EXT_MAX 256 /* max # of db extends */

typedef unsigned int adb_id_t ;

typedef enum
{
  DEBUG_OFF = 0 ,
  DEBUG_1 = 1 ,
  DEBUG_2 = 2 ,
  DEBUG_3 = 3 ,
  DEBUG_4 = 4 ,
  DEBUG_ADDR = 5 ,
  DEBUG_6 = 6 ,
} debug_t ;

typedef enum
  {
    ADB_FIELD_INT ,
    ADB_FIELD_STRING , /* e.g. fixed length */
    ADB_FIELD_LONG_LONG ,
    ADB_FIELD_DOUBLE ,
    ADB_FIELD_UNSIGNED_INT, /* int */
    ADB_FIELD_BLOB ,
    ADB_FIELD_BLOB_STRING ,
    ADB_FIELD_VSTRING, /* size 0 - 110k max ~1M - field contains length && ptr */
    ADB_FIELD_LINK, /* "inheritance" or reference or .... , *no-index* */
    ADB_FIELD_CONTAINER, /* same as LINK but w/o "reference integrity" 
			  useful only in internal file __refs , *no-index* */
    ADB_FIELD_WCHAR, /* multibyte vstring */
    ADB_FIELD_VOID, /* similar to VSTRING, can't be part of index */
    ADB_FIELD_PTR_DIFF,
    ADB_FIELD_UNSIGNED_LONG_LONG,
  } adb_field_type_t ;

struct ADB_FIELD
{
  adb_magic_t magic ;
  adb_tavl_node_t node ;
  char name[ADB_NAME_MAX] ;
  unsigned int len ; /* 0 unlimited */
  adb_id_t id ;
  adb_field_type_t type ;
  int offset ; /* data storage begin */
} ;
typedef struct ADB_FIELD adb_field_t ;

struct ADB_VSTRING
{
  adb_magic_t magic ;
  size_t size ; /* with terminating 0 */
  size_t offset ; /* 0 == (adb_rec_t *) */
} ;
typedef struct ADB_VSTRING  adb_vstring_t ;

struct ADB_WCHAR
{
  adb_magic_t magic ;
  size_t size ; /* wchar_t */
  size_t offset ; /* wchar_t */
/*   size_t tsize ; */ /* transformed wchar_t */
/*   size_t toffset ; */ /* transformed wchar_t */
} ;

typedef struct ADB_WCHAR adb_wchar_t ;

#define ADB_IDX_SIZE_MAX 32

struct ADB_META_FILE
{
  adb_magic_t magic ;
  adb_tavl_node_t node ;
  char name[ADB_NAME_MAX] ;
  adb_id_t id ;
  adb_tavl_table_t fields ; 
/*   adb_bh_t *fields_bh ; */
  adb_tavl_table_t indexes /* , *__indexes  */; /* adb_file_t * */
/*   adb_bh_t *indexes_bh ; */
  int idx_size ; /* last used offset + 1 */
  int idx_alloc ; /* allocated */
  adb_field_t /* **idx , */ **__idx ; /* primary index */
  int order_size ; /* allocated */
  adb_field_t /* **order , */ **__order ; /* storage order */
  int last_order ;
  int all_data_size ; /* sum of data size  */
  off_t data_start ;
  adb_magic_t data_start_type ; /* single tree / nth (st)range tree */
/*   adb_db_t *db ; */
  int nfd ; /* nth open fd of database */
/*   int fd ; */
 /*  int blob_fd ; */ /* BLOBs can't be part of index 
		   => stored only once in primary tree */
  size_t block_size ; /* USE !!! */
  char has_link ; /* TRUE if those infernal field type is present here */
  /*   unsigned char secondary ; */
  struct ADB_FILE *__parent ;
} ;

typedef struct ADB_META_FILE adb_meta_file_t ;

/* split: malloc / meta-scheme */

typedef struct ADB_FILE adb_file_t ;

struct ADB_FILE
{
  adb_magic_t magic ;
  tavl_node_t node ;
  int count ; /* # of open() */
  adb_meta_file_t *meta ;
  adb_file_t *parent ; /* master index */
  adb_file_t **sis ; /* array of secondary indexes */
/*   adb_tavl_node_t node ; */
/*   char name[ADB_NAME_MAX] ; */
/*   adb_id_t id ; */
/*   adb_tavl_table_t fields ; */
/*   adb_bh_t *fields_bh ; */
  adb_tavl_table_t *fields , *indexes ;
/*   adb_tavl_table_t indexes ; */ /* adb_file_t * */
/*   adb_bh_t *indexes_ta ; */
/*   int idx_size ; */ /* last used offset + 1 */
/*   int idx_alloc ; */ /* allocated */
  adb_field_t **idx /* , **__idx */ ; /* primary index */
/*   int order_size ; */ /* allocated */
  adb_field_t **order/*  , **__order */ ; /* storage order */
/*   int last_order ; */
/*   int all_data_size ; */ /* sum of data size  */
/*   off_t data_start ; */
/*   adb_magic_t data_start_type ; */ /* single tree / nth (st)range tree */
  adb_db_t *db ;
/*   int nfd ; */ /* nth open fd of database */
  int fd ;
  int blob_fd ; /* BLOBs can't be part of index 
		   => stored only once in primary tree */
  struct ADB_TNX_XIP *xip ; /* AI/BI ptr */
/*   size_t seg_size ; */
/*   unsigned char secondary ; */
/*   struct ADB_FILE *__parent ; */
 /*  char pseudo ; */ /* e.g. link's private file => no meta AI/BI */
}  ;

struct ADB_REF
{
  adb_magic_t magic ; 
  off_t bh_offset ; /* #4-11 */
  unsigned int diff ; /* #12-15 */
  size_t size ;  /* #16-19 */
  adb_meta_file_t *__mfile ; /* points to META file */ /* #20-23 */
} ;

typedef struct ADB_REF adb_ref_t ;

struct ADB_VALUE_LIST
{
  adb_field_t *fld ;
  void *value ; /* malloc'ed */
} ;

struct ADB_VALUE
{
  int n ;
  struct ADB_VALUE_LIST **vl ;
} ;

typedef struct ADB_VALUE adb_val_t ; 

struct ADB_LINK
{
  adb_magic_t magic ; /* ADB_MAGIC_LINK */
  unsigned long long count ;
  unsigned long long id ;
  /* key to db->link file is (mfile, offset of record, offset of link, adb_ref_T ) */
} ;

typedef struct ADB_LINK adb_link_t ;
typedef struct ADB_LINK adb_container_t ;

struct ADB_LINK_TRAVERSER
{
  adb_rec_t *rec ;
  adb_link_t *link ;
  adb_bh_t *bh ; /* of rec */
  adb_file_t *file ;
  int pos ; /* in link->count */
} ;

typedef struct ADB_LINK_TRAVERSER adb_link_traverser_t ;

#define ADB_SHM_SIZE 0x100000 /* 1M */
#define ADB_USERS_MAX 1024 /* 1st element of /proc/sys/kernel/sem */

typedef enum
  {
    ADB__LOCK_NULL    = 0,
    /* used "internaly */
    ADB__LOCK_AREAD   = 1, /* :1 I claim lock somewhere lower  */
    ADB__LOCK_AWRITE  = 2, /* :2 dtto */
    ADB__LOCK_READ    = 3, /* :3 don't write/delete */
    ADB__LOCK_WRITE   = 4, /* :4 don't read */
    /* looow level */
    ADB__LOCK_UPDATE = 5, /* :5 I'm playing with this lock */
    /* miscelanous */
    ADB__LOCK_EXTEND = 6, /* extending db */
    ADB__LOCK_META = 7, /* meta-scheme manglink in progress */
    ADB__LOCK_AI = 8, 
    ADB__LOCK_UNUSED_SINGLE = 9,
    ADB__LOCK_UNUSED_MULTI = 10,
    ADB__LOCK_START = 11, /* starting DB */
    ADB__LOCK_LINK = 12, /* increase sb->last_link_id */
  } _adb_lock_t ;


typedef enum
  {
    ADB_LOCK_NULL = 0 ,
    ADB_LOCK_AREAD = 1 << ADB__LOCK_AREAD , /* 0x2 */
    ADB_LOCK_AWRITE = 1 << ADB__LOCK_AWRITE , /* 0x4 */
    /* interface */
    ADB_LOCK_READ = 1 << ADB__LOCK_READ , /* 0x8 */
    ADB_LOCK_WRITE = 1 << ADB__LOCK_WRITE , /* 0x10 */
    ADB_LOCK_UPDATE = 1 << ADB__LOCK_UPDATE , /* 0x20 */
    /* misc */
    ADB_LOCK_EXTEND = 1 << ADB__LOCK_EXTEND,
    ADB_LOCK_META = 1 << ADB__LOCK_META ,
    ADB_LOCK_AI = 1 << ADB__LOCK_AI ,
    ADB_LOCK_UNUSED_SINGLE = 1 << ADB__LOCK_UNUSED_SINGLE ,
    ADB_LOCK_UNUSED_MULTI = 1 << ADB__LOCK_UNUSED_MULTI,
    ADB_LOCK_START = 1 << ADB__LOCK_START,
    ADB_LOCK_LINK = 1 << ADB__LOCK_LINK ,
  } adb_lock_t ;

typedef enum
  {
    ADB_LOCK_FILE = 0x1,
    ADB_LOCK_SEG  = 0x2,
    ADB_LOCK_REC  = 0x4,
  } adb_lock_scope_t ;

#define CONFIG_SMP
#include "bitops.h"


struct ADB_LOCK_THELOCK
{
  adb_lock_t lock ;
  unsigned int usage ; /* # of processes sharing this lock READ */
  unsigned int ausage ; /* # of processes sharing this lock AREAD */
  unsigned int awusage ; /* # of processes sharing this lock AWRITE */
  unsigned int waiting ;
  int sem ; /* sem_num */
  pid_t pid ;
} ;
typedef struct ADB_LOCK_THELOCK  adb_lock_atom_t ;

typedef int adb_lock_cb_func_t(adb_db_t *, adb_lock_atom_t *,_adb_lock_t );
typedef void * adb_op_func_t(adb_bh_t *, adb_tavl_traverser_t *);

/* whole file lock */
struct ADB_LOCK_FILE
{
  adb_magic_t magic ;
  tavl_node_t node ;
  adb_file_t *file ; /* same order as FTS !!! */
  adb_lock_atom_t la ;
  /*   adb_id_t id ; */ /* file->id */
} ;

typedef struct ADB_LOCK_FILE  adb_lock_file_t ;

/* segment lock */
struct ADB_LOCK_SEG
{
  adb_magic_t magic ;
  tavl_node_t node ;
  adb_file_t *file ;
  adb_lock_atom_t la ;
  off_t offset ;
}  ;
typedef struct ADB_LOCK_SEG adb_lock_seg_t ;

/* typedef struct ADB_LOCK_REC */
/* { */
/*   adb_lock_atom_t la ; */
/*   off_t offset ; */
/* } adb_lock_rec_t ; */

#define ADB_NSEMS ADB_USERS_MAX/sizeof (int)

/* SHM/Lock superblock */
struct ADB_LOCK_SB
{
  /* !!!!!!!!!!! first three items MUST be same as adb_mm_t !!!!!!!!! */
  adb_magic_t magic ;
  size_t size ;
  size_t map_size ;
  /* !!!!!!!!!!! first three items MUST be same as adb_mm_t !!!!!!!!! */
  adb_lock_atom_t la ;
  adb_mode_t mode ; /* USE!!!! single/multi ... */
  tavl_table_t *file_tree ; /* tree of file_id stuffed with lock,queue, seg_tree */
  tavl_table_t *seg_tree ; /* of adb_lock_seg_t */
  tavl_table_t *rec_tree ; /* of adb_lock_seg_t TOO */
  tavl_table_t __file_tree ; /* tree of file_id stuffed with lock,queue, seg_tree */
  tavl_table_t __seg_tree ; /* of adb_lock_seg_t */
  tavl_table_t __rec_tree ; /* of adb_lock_seg_t TOO */
  int sems[ADB_NSEMS] ;
} ;
typedef struct ADB_LOCK_SB adb_lock_sb_t ;

#define ADB_MODE(db) (db->sb->mode)

struct ADB_PTS /* pid to sem SHM */
{
  adb_lock_t lock ;
  pid_t pid ;
  int sem_id ;
} ;
typedef struct ADB_PTS  adb_pts_t ;

#define ADB_PTS_SIZE ((sizeof(adb_pts_t)) * ADB_USERS_MAX)


struct ADB_XI_HDR
{
  adb_magic_t magic ;
  int nth_fd ;
  off_t offset ;
  size_t size ;
} ;

typedef struct ADB_XI_HDR adb_xi_hdr_t ;

struct ADB_SB
{
  adb_magic_t magic ;
  long long size ;
  adb_mm_t *meta ;
  adb_tavl_table_t __files ; 
/*   adb_tavl_table_t *files ;  */
  adb_id_t last_id ;
  adb_id_t last_range_id ;
/*   unsigned int addr ; */ /* addr of mmaped meta scheme */
  adb_mode_t mode ; /* same as ADB_LOCK_SB->mode */
  char bi_dir[ADB_NAME_MAX] ;
  char ai_dir[ADB_NAME_MAX] ;
  char ai_file[ADB_NAME_MAX] ; 
  char *ext[ADB_EXT_MAX] ;
  char *__nick ; /* dbname */
/*   adb_bh_t __bh ; */ /* for files && indexes */

/*   adb_id_t last_file_id ; */
/*   adb_id_t last_field_id ; */
/*   adb_id_t last_index_id ; */
  unsigned long long last_link_id ;
};
typedef struct ADB_SB  adb_sb_t ;

struct ADB_DB
{
/*   adb_magic_t magic ; */
  adb_sb_t *sb ;
  adb_mm_t *mm ;
  adb_tavl_table_t *files ; /* &db->__files */
  adb_bh_t *files_bh ; /* files & CO */
  tavl_table_t open_files ; /* of adb_iles_t * */
  unsigned int addr ; /* where is meta-scheme mmaped */
/*   int mode_ai , mode_bi ; */
  int nfd ;
  int fds[ADB_EXT_MAX+1] ; /* +1 base file with meta-scheme */
  int ai_fd ;
  int shmid /* , ptsid */ /* pid to sem SHM */;
  int semid ;
  void *shm , *pts_shm ;
  adb_lock_sb_t *lock_sb ;
  int last_range_id ;
  adb_file_t *back_link , *free_list , *link ;
  int meta_bi_fd ;
  char *meta_bi_name ;
  char *name ;
  char *nick ;
  void *zbuf ;
  unsigned long long last_link_id ;
};

/* block header */
struct ADB_BH 
{
  adb_magic_t magic ;
  tavl_node_t node ; /* node MUST be second !!!!, same as adb_rec_t , adb_range_t */
  adb_tnx_state_t state ;
  unsigned int addr ; /* addr , was: byte_t * */
  size_t size ;
  adb_file_t *file ;
  adb_db_t *db ;
  int (*cmp)(const void *, const void *, const void * UNUSED, int );
  adb_mm_t *m ;
  adb_tavl_table_t *tree ; /* in data block &m->tree */
  off_t offset ; /* of current (THIS) block header */
  void *zbuf ;
  size_t zsize ;
}/*  adb_bh_t */ ;


/* #define ADB_TNX_LIST_SIZE 32 */


struct ADB_TNX_FILE_SEGS
{
  adb_magic_t magic ;
  tavl_node_t node ;/* node MUST be second !!!!, same as adb_rec_t , adb_range_t */
  adb_file_t *file ;
  /*   adb_id_t id ; */ /* file id */
  /* file id isn't unique, when more whan one database is in use !!!! */
  tavl_table_t *atoms ; /* of adb_bh_t */
}  ;
typedef struct ADB_TNX_FILE_SEGS adb_tnx_file_segs_t ;

/* BI pointer */
struct ADB_TNX_XIP 
{
  adb_magic_t magic ;
  tavl_node_t node ; /* node MUST be second !!!!, same as adb_rec_t , adb_range_t */
  adb_sb_t *sb ;
  adb_db_t *db ;
  char *bi_name ;
  char *ai_name ;
  int bi_fd ;
  int ai_fd ;
} ;

typedef struct ADB_TNX_XIP adb_tnx_xip_t ;

/* transaction */
struct ADB_TNX 
{
  adb_magic_t magic ;
/*   adb_tnx_state_t state ; */
  tavl_table_t *files ; /* of adb_tnx_file_segs_t */
  adb_tnx_id_t id ;
  tavl_table_t *xips ; /* AI/BI of adb_tnx_xip_t */
}  ;

typedef struct ADB_TNX adb_tnx_t ;


typedef enum /* those symbolic names are BI write wise */
  {
    ADB_TNX_TYPE_BLOCK      =  1, /* gziped segment */ 
    ADB_TNX_TYPE_FILE_TYPE  =  2, /* meta_file->data_start_type, 
				     old/new value in offset */
    ADB_TNX_TYPE_FILE_START =  3, /* meta_file->data_start offset, 
				     old/new value in offset */
    ADB_TNX_TYPE_BLOCK_ADD  =  4,
    ADB_TNX_TYPE_BLOCK_DEL  =  5,
    ADB_TNX_TYPE_BLOCK_META =  6,
  } adb_tnx_type_t ;

struct ADB_TNX_HDR
{
  adb_magic_t magic ; /* AI/BI */
  adb_tnx_type_t type ;
  int nfd ; /* index of db->fds[] */
  size_t size ; /* of payload w/o this header */
  size_t orig_size ; /* size of uncompressed block */
  adb_meta_file_t *__meta ; /* rel ptr */
  off_t offset ;
/*   void *data ; */ /* payload */
} ;

typedef struct ADB_TNX_HDR  adb_tnx_hdr_t ;

typedef enum
  {
    ADB_RANGE_FLAG_NULL  = 0x0,
    ADB_RANGE_LEFT_INF  = 0x1, /* -INF */
    ADB_RANGE_RIGHT_INF = 0x2, /* +INF */
  } adb_range_flag_t ;

/* range has record @  ( range + 1 ) 
 *
 * memory :
 * range
 * record 
 */
#if 0
#define ___~~~~~ADB_RANGE_TO_REC(range) (adb_rec_t *)( range + 1 )
#endif /* 0 */



struct ADB_RANGE
{
  adb_magic_t magic ;
  adb_tavl_node_t node ;
  adb_range_flag_t flag ;
  off_t offset ; /* tree/range block */
  adb_magic_t data_start_type ;
  adb_id_t id ;
}  ;

typedef struct ADB_RANGE adb_range_t ;


/* traverser */
struct ADB_TR 
{
  int height ; /* # of traversers */
  char init ; /* initialized */
  adb_bh_t **bhs ;
  adb_range_t **ranges ;
  adb_tavl_traverser_t **trs ;
} ;

typedef struct ADB_TR adb_tr_t ;

typedef struct _ADB_WALK
{
  adb_tnx_t *tnx ;
  adb_file_t *file ;
  void (*func)() ;
  void *param ;
} adb_walk_t ;

typedef enum
  {
    ADB_BH_DIG_INSERT = 0 ,
    ADB_BH_DIG_FIND   = 1 ,
  } adb_bh_dig_t ;

#if __GNUC__ >= 2
#define unused __attribute__ ((unused))
#else
#define unused
#endif

/* 11.9:   What's the difference between "const char *p" and */
/*         "char * const p"? */

/* A:      The former declares a pointer to a constant character; the */
/*         latter declares a constant pointer to a character. */

/* Interface */

adb_tnx_t *adb_tnx_new ( void );
void adb_tnx_end PARAMS((adb_tnx_t **tnx));
void adb_range_show PARAMS((adb_bh_t *rbh, adb_file_t *file,char *func));
int adb_find_by_name PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_tr_t *tr , 
		 const adb_rec_t ** const _rec, int exact, ... ));
int adb_next PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_tr_t *tr , const adb_rec_t ** const  _rec));
int adb_prev PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_tr_t *tr , const adb_rec_t ** const _rec));
int adb_fld_get PARAMS((adb_file_t *file, const adb_rec_t * const rec, ... ));
int adb_delete PARAMS((adb_tnx_t *tnx, adb_file_t *file, const adb_rec_t * const rec ));
int adb_tr_first PARAMS((adb_tnx_t *tnx , adb_file_t *file, adb_tr_t *tr, const adb_rec_t ** const _rec));
int adb_tr_last PARAMS((adb_tnx_t *tnx , adb_file_t *file, adb_tr_t *tr, const adb_rec_t ** const _rec));
void adb_tr_free PARAMS((adb_tr_t *tr));
int adb_lock_claim PARAMS((adb_file_t *file, off_t, off_t, adb_lock_scope_t , adb_lock_t _type));
int adb_lock_free PARAMS((adb_file_t *file, off_t ,off_t, adb_lock_scope_t, adb_lock_t _type));
adb_file_t *adb_file_open PARAMS((adb_db_t *, char *filename));
adb_file_t *Adb_adb_file_open PARAMS((adb_db_t *db, adb_meta_file_t *mfile));
adb_meta_file_t *adb_create_file PARAMS((adb_db_t *,char *name, int));
adb_field_t *adb_create_field PARAMS(( adb_db_t *, adb_meta_file_t *file, char *name, adb_field_type_t type, unsigned int len, int order));
void adb_blob_free PARAMS((adb_blob_t *blob));
adb_blob_t *adb_blob_create PARAMS((size_t size, adb_blob_flag_t flag, void *arg));
adb_rec_t * adb_insert_by_name PARAMS((adb_tnx_t *, adb_file_t *file, ... ));
int adb_test_create_files PARAMS((adb_db_t *,int endless));
void adb_show_files PARAMS((adb_db_t *));
void *Malloc PARAMS((size_t size));
int adb_insert_test PARAMS(());
void adb_walk PARAMS((adb_tnx_t *tnx, adb_file_t *file, void (*func)() , void *param));
int adb_next_by_name PARAMS((adb_tnx_t *tnx, adb_bh_t *bh, adb_file_t *file,  ... ));
adb_db_t * adb_open PARAMS((char *dbname,int ));
void adb_close PARAMS((adb_db_t *));
adb_db_t *adb_creat PARAMS((char *dbname, char *ext[], int ));
void adb_sweep PARAMS((adb_db_t *));
int adb_walk_test PARAMS(());
void adb_dump PARAMS((adb_db_t *, char *filename, char *dumpfile));
void adb_tex PARAMS((adb_tnx_t *tnx, adb_file_t *file, char *dir));
adb_meta_file_t *adb_create_file_by_name PARAMS((adb_db_t *db, char *name, ... ));
adb_file_t *adb_file_open_use_index PARAMS((adb_db_t *db, char *filename, char *idx_name));
adb_meta_file_t *adb_create_index_by_name PARAMS((adb_db_t *, adb_meta_file_t *file, int nth_ext, char *name, ... ));
int adb_obj_ref_init PARAMS((adb_file_t *file, adb_rec_t *rec, char *name, adb_file_t *rf));
int adb_obj_has_a PARAMS((adb_tnx_t *, char *, adb_file_t *, adb_rec_t *,adb_file_t *, adb_rec_t *));
adb_rec_t *adb_link_read PARAMS((adb_tnx_t *tnx, adb_link_traverser_t *lt));
adb_link_traverser_t *adb_link_get PARAMS((adb_tnx_t *tnx, adb_file_t *file, const adb_rec_t *rec, char *name));
void adb_link_free PARAMS((adb_link_traverser_t *lt));
void adb_meta_commit PARAMS((adb_db_t *db));
void adb_meta_abort PARAMS((adb_db_t *db));
void adb_meta_open PARAMS((adb_db_t *db));
void adb_bi_start PARAMS((adb_db_t *, char *));
void adb_ai_start PARAMS((adb_db_t *, char *, char *));
void adb_tnx_abort PARAMS((adb_tnx_t **tnx));
void adb_ai_stop PARAMS((adb_db_t *db));
void adb_bi_stop PARAMS((adb_db_t *db));
adb_db_t * adb_start_db PARAMS((char *dbname, int multi_user ));
void adb_stop PARAMS((char *dbname));
adb_db_t *adb_start_db_single PARAMS((char *dbname, char **ext));
adb_db_t *adb_start_db_multi PARAMS((char *dbname, char **ext));
int adb_find_first_where PARAMS((adb_tnx_t *, adb_file_t *, adb_tr_t * , 
				 const adb_rec_t ** const , ... ));

/**********************************************************************************/
/*                         Interface end                                          */
/**********************************************************************************/
#ifdef  __ADB
adb_field_t *Adb_fld_find __P((adb_file_t *, char *));
adb_bh_t *Adb_file_activate PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_tnx_state_t state));
void *Adb_malloc PARAMS((adb_file_t *, size_t size, adb_mm_t *, const char *));
void *Adb_malloc0 PARAMS((adb_file_t *, size_t size, adb_mm_t *, const char *));
void Adb_free PARAMS((adb_file_t *, unsigned char *real_addr , size_t size, adb_mm_t *, const char *));
void * adb_lock_init PARAMS((adb_db_t *db, char *dbname));
char *Adb_name_db PARAMS((char *dbname));
char *Adb_name_bi PARAMS((adb_db_t *, char *db));
char *Adb_name_ai PARAMS((adb_db_t *, char *db));
/* inline byte_t *__to_real_addr PARAMS((byte_t *bit_map_addr, byte_t new_bits , byte_t *map, byte_t *pool)); */
/* byte_t *adb_meta_malloc PARAMS((size_t size, adb_mm_t *m)); */
/* void adb_meta_free PARAMS((byte_t *real_addr ,  adb_mm_t *m, size_t size)); */
adb_bh_t *Adb_tnx_add PARAMS((adb_tnx_t *tnx, adb_file_t *, adb_tnx_state_t , unsigned char  *addr , size_t size, off_t ));
void Adb_seg_init PARAMS((adb_db_t *, adb_bh_t *,unsigned char *base, size_t size, adb_magic_t, int, off_t ));
adb_bh_t *Adb_seg_add PARAMS((adb_tnx_t *tnx,adb_file_t *file, off_t *start, adb_magic_t content, int level, off_t ));
adb_bh_t *Adb_seg_attach PARAMS((adb_tnx_t *tnx,adb_file_t *file, off_t start, adb_tnx_state_t ));

adb_bh_t *Adb_seg_load PARAMS((adb_tnx_t *tnx,adb_file_t *file, off_t offset, adb_tnx_state_t));
int Adb_field_cmp PARAMS((const void *a, const void *b, 
			 const void *param UNUSED, int UNUSED));

int Adb_file_cmp PARAMS((const void *a, const void *b, 
			const void *param, int UNUSED));

/* byte_t *adb_meta_malloc0 PARAMS((size_t size, adb_mm_t *m)); */
/* int adb_tnx_last_seg PARAMS((adb_tnx_t *tnx, adb_file_t *,byte_t **addr )); */
void Adb_data_show PARAMS((const void *data, adb_file_t *file));
void Adb_seg_unload PARAMS((adb_tnx_t *tnx, adb_bh_t *bh, int));
void Adb_check_bh PARAMS((adb_bh_t *bh, char *,int ));
int Adb_data_cmp PARAMS((const void *_a, const void *_b, const void *_param, int ));
int Adb_range_cmp PARAMS((const void *_a, const void *_b, 
			  const void *_param, int UNUSED ));
void Adb_tnx_bi PARAMS((const adb_tnx_type_t type, const adb_bh_t *bh, const void *_addr, size_t size));
error_t adb_parse_opt PARAMS((int key, char *arg, struct argp_state *state));
void Adb_blob_insert PARAMS((adb_file_t *file, adb_rec_t *rec));
inline void Adb_lock_claim_sb_with PARAMS((adb_db_t * ,_adb_lock_t type));
inline void Adb_lock_free_sb_with PARAMS((adb_db_t *, _adb_lock_t type));
size_t Adb_vsize_get PARAMS((adb_file_t *file, adb_rec_t *rec));
void *tavl_root PARAMS((adb_bh_t *bh));
char *Adb_magic PARAMS((adb_magic_t magic));
void Adb_create_range PARAMS((adb_tnx_t *tnx, adb_bh_t *bh , adb_file_t *file));
adb_bh_t *Adb_seg_split_inf PARAMS((adb_tnx_t *tnx, adb_bh_t *fail_bh, adb_file_t *file));
adb_bh_t *Adb_seg_split PARAMS((adb_tnx_t *tnx, adb_bh_t *fail_bh, adb_file_t *file));
adb_bh_t *Adb_tnx_find_parent PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_bh_t *child ));
int Adb_tnx_file_id_cmp PARAMS((const void *a, const void *b, void *param UNUSED ));
int Adb_tnx_offset_cmp PARAMS((const void *a, const void *b, void *param UNUSED ));
void Adb_seg_dirty PARAMS((adb_tnx_t *, adb_bh_t *bh));
adb_tnx_file_segs_t *Adb_find_file_in_tnx PARAMS((adb_tnx_t *tnx, adb_file_t *file));
adb_bh_t *Adb_bh_find PARAMS((adb_tnx_t *tnx, adb_file_t *file, off_t offset ));
adb_bh_t *Adb_tnx_find_parent_bh PARAMS((adb_tnx_t *tnx, adb_bh_t *child, adb_file_t *file));
void Adb_show_one_range PARAMS((adb_range_t *range, adb_bh_t *bh, adb_file_t *file));
void Adb_cs_range PARAMS(( adb_tnx_t *, adb_bh_t * , adb_file_t *));
void Adb_malloc_register PARAMS((adb_file_t *, void *ptr, adb_bh_t *bh, size_t size));
void Adb_malloc_undo();
void Adb_malloc_register_forget();
adb_rec_t *adb_range_to_rec PARAMS((adb_range_t *range));
void Adb_range_verify PARAMS((adb_tnx_t *tnx, adb_bh_t *rbh, adb_file_t *file, adb_rec_t **last));
void Adb_verify_tree_content PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_bh_t *bh, adb_rec_t **last));
void Adb_tr_free PARAMS((adb_tr_t *tr));
void Adb_tnx_clean PARAMS((adb_tnx_t *tnx, adb_file_t *file));
void adb_range_zap_empty PARAMS((adb_tnx_t *tnx,adb_file_t *file,adb_bh_t *bh));
void *Malloc0 PARAMS((size_t size));
void Adb_meta_rw PARAMS((adb_db_t *db));
void Adb_meta_ro PARAMS((adb_db_t *db));
adb_bh_t *Adb_new_fake_bh PARAMS((adb_db_t *, int (*cmp)(), adb_tavl_table_t *tree ));
void Adb_free_fake_bh PARAMS((adb_bh_t *bh));
void *Adb_safe_malloc PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_rec_t *_rec , adb_bh_t **bhp, size_t size , int *));
adb_bh_t *Adb_bh_dig PARAMS((adb_tnx_t *tnx , adb_file_t *file, adb_rec_t *_rec , adb_tr_t *tr, adb_bh_dig_t ));
void Adb_link_update PARAMS((adb_tnx_t *tnx, adb_file_t *file, adb_bh_t *old_bh, adb_rec_t *old_rec, adb_bh_t *new_bh, adb_rec_t *new_rec));
void Adb_tnx_check PARAMS((adb_tnx_t *tnx));
void Adb_link_test PARAMS((adb_bh_t *bh, adb_rec_t *rec));
void Adb_tnx_set_data_start PARAMS((adb_file_t *file, off_t *start, off_t new_val));
void Adb_tnx_set_data_start_type PARAMS((adb_file_t *file, adb_magic_t *type, 
					adb_magic_t new_type));
void Adb_tnx_bi_open PARAMS((adb_tnx_t *tnx, adb_file_t *file));
void Adb_seg_bi_type PARAMS((adb_tnx_type_t type, adb_file_t *file, off_t offset));

char *Adb_name_db_nick PARAMS((char *_name, char **));
void Adb_mkdir PARAMS((char *dir, int mode));
void Adb_seg_ai_type PARAMS((adb_tnx_type_t type, adb_file_t *file, off_t offset));
void adb_tnx_apply_ai PARAMS((adb_db_t *db, char *ai_file));
inline int Adb_lock_test_sb_with PARAMS(( adb_db_t *db, _adb_lock_t type));
void Adb_ai_stop PARAMS((adb_db_t *db));
void Adb_bi_stop PARAMS((adb_db_t *db));
char *Adb_name PARAMS((char *dbname, char *ext));
void Adb_tnx_mass_undo PARAMS((adb_db_t *db));
/* char *_adb_wchar_to_char PARAMS((iconv_t cd, wchar_t *wc)); */

/* ********************* EOF prototypes ********************************** */


/* aliases */
#if 0
#define adb_meta_malloc0(size, m ) __adb_malloc0(size, m)
#define adb_meta_malloc(size, m ) __adb_malloc(size, m)
#define adb_meta_free(item, size, m) __adb_free(item, size, m)
#endif 
/* byte_t *adb_meta_malloc0() __attribute__ ((weak, alias ("__adb_malloc0"))); */
/* byte_t *adb_meta_malloc() __attribute__ ((weak, alias ("__adb_malloc"))); */
/* void adb_meta_free() __attribute__ ((weak, alias ("__adb_free"))); */

#define SEG(a) ((unsigned int) a)
#define ADB_FULL ( (void **) EOF )
#define ADB_DUP  ( (void **) -2  )

#define CMP(TYPE, A, B) (*(TYPE *)A > *(TYPE *)B) - (*(TYPE *)A < *(TYPE *)B)
#define ADB_LCMP(A,B) (( A > B ) - ( A < B))

/* #define INSERT_RANGE(rbh,item) adb_avlt_insert( rbh->m->tree, __range_cmp, SEG(rbh->addr), item , &item->item ) - SEG(rbh->addr) */

#endif /*  __ADB */
enum ADB_DEBUG
  {
    ADB_DEBUG_MISC      = 0x1,
    ADB_DEBUG_VM        = 0x2,
    ADB_DEBUG_RANGE_CMP = 0x10,
    ADB_DEBUG_DATA_CMP  = 0x20,
    ADB_DEBUG_INDEX     = 0x40,
    ADB_DEBUG_LINK      = 0x80,
    ADB_DEBUG_EXIT      = 0x100000,
  } ;
#ifdef  __ADB

#ifdef MAIN
adb_mm_t *adb_mm ;
adb_sb_t *adb_sb ;
int adb_fd ;
int  Adb_debug ;
char zbuf[ sizeof(adb_tnx_hdr_t) + 1053737] ;
size_t adb_page_size ;

#if 0
int adb_shmid , adb_semid , adb_ptsid /* pid to sem SHM */ ;
void *adb_shm , *adb_pts_shm ;
int Adb_bi_fd, Adb_ai_fd /* gloabal one */, __adb_ai_proc_fd ;
char Adb_mode_bi = 0 , Adb_mode_ai = 0 ;
adb_lock_sb_t *Adb_lock_sb ;
#endif
int adb_errno ;
FILE *L ;
jmp_buf jb ;
unsigned int Adb_file_blocks_max = 128 ;
#else /* MAIN */
extern char zbuf[1053737] ;
extern size_t adb_page_size ;
extern int  Adb_debug ;

extern FILE *L ;
extern int adb_errno ;
extern jmp_buf jb ;
extern unsigned int Adb_file_blocks_max ;
#endif /* MAIN */
#else /*  __ADB */ /* API visible stuff */
extern int  Adb_debug ;
extern unsigned int Db_file_blocks_max ;
extern int adb_errno ;
#endif /*  __ADB */

#define ADB_ZBUF_SIZE 1053737
#define ADB_ZBUF_COUNT 16

/* extern struct argp adb_argp ; */
/* extern struct argp_child adb_argp_child[] ; */
#define ADB_ERR_SUCCESS         0
#define ADB_ERR_DUPLICITY       1
#define ADB_ERR_EMPTY_IDX_FIELD 2 
#define ADB_ERR_NOT_FIELD       3
#define ADB_ERR_NO_RECORD       4
#define ADB_ERR_INVALID_DATA    5
#define ADB_ERR_EMPTY_DB        6
#define ADB_ERR_SEC_IDX         7
#define ADB_ERR_CROSS_DB_LINK   8
#define ADB_ERR_TOO_MANY_LINKS  9

#define ADB_ERROK() adb_errno = ADB_ERR_SUCCESS

#define ADB_ERROR(format, args... ) g_error("%s [%d] %s:%d errno %d `%s\' - " format, __FUNCTION__, getpid(), __FILE__,__LINE__, errno, sys_errlist[errno], ## args )

#define ADB_WARNING(format, args... ) g_warning("%s [%d] %s:%d errno %d `%s\' - " format, __FUNCTION__, getpid(), __FILE__,__LINE__, errno, sys_errlist[errno], ## args )

#define ADB_BUG(format) g_error("%s %s:%d errno %d `%s\' - " format, __FUNCTION__, __FILE__,__LINE__, errno, sys_errlist[errno])

#define Adb_lock_claim_sb(db) Adb_lock_claim_sb_with(db,ADB__LOCK_UPDATE)
#define Adb_lock_free_sb(db) Adb_lock_free_sb_with(db,ADB__LOCK_UPDATE)

#define DATA(p) ((void *)p - offsetof( struct ADB_RECORD, node ) )
#define NODE(p) ((void *)p + offsetof( struct ADB_RECORD, node ) )

#define META(db, p) __adb_meta_rw(db) ; p ; __adb_meta_ro(db)

END_C_DECLS

#endif /* !_ADB_H */


