-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "morewidgets"

-- First unlink the current tree.

if aviation.running then
   resources.dofile "aviation/stop.lua"
end

aviation.nodes = {}
aviation.running = true

-- Then take it from the top.

resources.dofile "aviation/nature.lua"

if options.survey then
   resources.dofile "aviation/surveyor.lua"
else
   resources.dofile "aviation/edge.lua"
end

-- And link the rest as well. 

aviation.nodes.events = frames.event {
   keypress = function(self, key)
		 print ("'" .. key .. "' pressed")

		 if key == 'q' then
		    common.iterate = false
		 elseif key == 'p' then
		    dynamics.timescale = dynamics.timescale > 0 and 0 or 1
		 end
	      end,

   keyrelease = function(self, key)
		   print ("'" .. key .. "' released")
		end
}

aviation.nodes.framerate = widgets.display {
   align = {1, 1},

   gauge = widgets.speedometer {
      color = {1.0, 0.8, 0.2},
      opacity = 0.6,
   },
}

aviation.nodes.framerate.parent = options.framerate and graph or nil
aviation.nodes.events.parent = graph
