-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- Define the tracksets.

airrace.tracksets = {
   flightschool = {
      description = "Flight school",
      
      [1] = {
	 description = "Happy hour",
         briefing = [[
You can hardly call this a track.  It has a single gate about 3 kilometers away from the starting point which should probably have a big exit sign above it.  The object is to get a first taste of what it takes to pilot a plane.
<p/>
The plane manages to stay in the air by generating lift to fight the gravitational pull towards the ground.  This is mostly generated by the wings although some part of it is generated by the fuselage and other parts of the aircraft as well.  In order to generate lift the plane needs to keep moving through the air.  Forward motion is also necessary to differentiate a plane from other kinds of flying vehicles such as balloons for example and is usually provided by a power plant.  Finally it is usually desirable to be able to steer the plane so some way of controlling the generated thrust and lift is also needed and this is accomplished with the throttle and control surfaces.
<p/>
There are various kinds of control surfaces but the basic set consists of ailerons, elevators and the rudder.  The ailerons are hinged sections on the trailing edge of the wings which can be deflected downwards or upwards in order to change the shape of the wing which in turn will cause a change in the produced lift.  When you push the stick to either side, one of the ailerons is deflected upwards and the other downwards, causing a difference in the lift generated by the two wings.  Since one wing is pushing more than the other a roll moment is produced which serves to bank the aircraft.
<p/>
Elevators work in a similar way.  Most planes have the elevators installed at the horizontal stabilizer which is a set of smaller horizontal wings mounted on the tail of the aircraft.  It serves the purpose of resisting upwards or downwards motion of the nose so as to keep the plane flying straight.  The elevators perform the same function as the ailerons, namely modifying the lift produced by the horizontal stabilizer.  But this added lift does not immediately make the plane climb or dive for two reasons.  To begin with the horizontal stabilizer is too small to produce enough lift to make the plane climb properly and besides it's too far away from the vehicle's center of gravity.  Additional lift on the stabilizer therefore results in the plane pitching upwards or downwards as if you were pushing on the tail of a scale model suspended at its center of gravity which usually happens to be somewhere between its wings.  But the plane only pitches upwards, apart from that it still happily keeps going in the same direction as before.  When there's a difference in the direction the plane's nose is pointing and the direction it's actually moving then the angle between the two directions is called the angle of attack and due to the design of the wings it so happens that the lift they produce is proportional to the angle of attack (generally, but up to a point).  So when you pull down on your stick both elevators are deflected so that your tail is pushed down, which pitches the nose up, increases the angle of attack of the wings and gives you additional lift which makes your plane climb.  The exact opposite happens of course when you push up on the stick.
<p/>
Finally there's another wing situated at the tail of your aircraft.  It sticks upwards and is therefore called the vertical stabilizer and it functions in much the same way as the horizontal stabilizer but instead of keeping you nose from pitching up or down it keeps it from yawing to the left or right.  There's also a control surface attached to it called the rudder which can adjust the lift produced by the horizontal stabilizer (which of course points sideways) to make the plane yaw.  Besides making fine adjustments to the aircraft's heading the rudder is often needed to stabilize it by compensating for unwanted yawing moments induced by turning or crosswinds for example.  You won't need to bother with it though as the plane is equipped with a yaw damper which takes care of adjusting the rudder for you.
<p/>
You can adjust the control surfaces by using the mouse.  Clicking the left button (once the timer has crossed zero and the autopilot has shut down) engages the stick.  Moving the mouse in any direction pushes the stick towards that direction and the distance by which the mouse pointer has been moved from its initial position at the time of the click determines how far the stick is pushed, how much the control surfaces deflect and, as a result, the extent of the aircraft's response.   Pushing the stick up will pitch the nose down and vice-versa.  Pushing it to either side will initiate a bank towards that side.  Clicking on the right mouse button allows you to control the rudder instead of the ailerons with the horizontal axis of your mouse while the button is held down.
<p/>
Fly around to get a feel for the response of the aircraft to your control inputs.  The only objective at this point is to keep clear of the ground and eventually fly through the gate to exit the track.
	 ]],
      },

      [2] = {
	 description = "Straight and level flight",
         briefing = [[
The object of this track is to fly a straight and level course through a set of five pylons spaced at increasing intervals.  Initially the autopilot will be engaged until your timer crosses zero seconds.  From this point onwards the plane will continue to fly uncontrolled.
<p/>
You might suppose, since no one is fiddling with the controls on the plane, that it should hold its current course but it will soon become evident that this not the case.  There are a number of reasons in fact why an airplane might alter its course or attitude besides steering by the pilot.  The lift produced by the wings for instance is proportional to the speed at which they move through the air so you will notice that as soon as the autopilot shuts down, the plane will start to pitch up and climb as it is gaining speed.  Other reasons such as turbulence or crosswinds exist but whatever the details it is clear that compensations have to be made.
<p/>
The first step in making corrections is estimating how much the aircraft is drifting from the desired course or attitude.  Pick a portion of the nose as a reference to aid you in estimating your plane's attitude.  The vertical distance from the nose to the horizon or the next gate can be used to gauge the plane's pitch and the elevators can be used by means of the stick to control it.  Try to keep your altitude steady by using the elevators to maintain a fixed distance from the top of the nose to your reference point.  Corrections to the height can be made by momentarily pitching the nose up or down to gain or loose height respectively.
<p/>
Corrections to keep the plane flying in a straight line can be done in much the same way.  This time you need to use the edge of your nose as a gauge and use it to estimate the plane's bank angle with respect to the horizon.  You can correct your bank by pushing the stick left or right.  Maintaining a non-zero bank angle will generally have the effect of changing the aircraft's heading.  If you find yourself diverging from the path to the next gate use the stick to momentarily bank the plane in the correct direction.  If you only need to make fine adjustments it might be preferable to use the rudder.
<p/>
As a final word of advice, try to keep your inputs to the plane's controls smooth and controlled.  Exaggerated inputs will result in exaggerated response from the aircraft which in turn will necessitate a large correction to compensate and so on.  It is not hard to totally lose control of the aircraft in this manner.  Also keep in mind that the aircraft has mass and therefore momentum.  If you're banking your plane to line up with the next gate for example and wait until you're actually lined up before starting to recover you will overshoot and have to bank the other way to compensate.  You can avoid this by properly coordinating your input.
	 ]],
      },

      [3] = {
	 description = "A gentle curve",
	 briefing = [[
This track will require you to gently maneuver the plane through a set of gates laid out on a wave-like curve.
<p/>
Initially you will be flying straight towards the first gate but as soon as that is cleared you will have to actively navigate your plane towards the others.  Heading changes can be most effectively accomplished by banking your aircraft.  Banking your wings has the effect of changing the orientation of the lift force produced by them.  Whereas it is normally pointing up, keeping your plane in the air it will now point to the side as well and this will make the plane turn.  As we have seen pulling down on the stick will increase the produced lift.  Normally, that is when the plane is level and the lift points upwards, this just changes the rate at which the aircraft is gaining height but if the wings are banked you can use the elevators to change the rate at which you're turning as well.  Pulling harder on the stick will make the plane turn faster.
<p/>
There are other consequences to this though.  The total lift produced generally depends on the elevator deflection and the airspeed but not on the bank angle.  Bank only alters its direction, in a way controlling how much on this lift points upwards and how much to the side.  What this means is that when you start banking the plane you will start turning but in addition to that you will also start losing height as some of the lift which was up to now used to fight gravity and keep you altitude constant is now used to change your heading.  This must be compensated by increasing the total lift and this can be best achieved by employing the elevators.  The gates have been positioned close to the ground in this track on purpose, to force you to keep your altitude constant as you turn towards the next gate.
<p/>
Try to keep your aircraft's path through the gates as smooth as possible by constantly correcting your bank angle and nose pitch to line up with the next gate in time and keep clear on the ground.  As always, remember to keep you controls smooth and accurate.
	 ]],
      },

      [4] = {
	 description = "Infinity",
	 briefing = [[
This track is sparse in terms of gates compared to the previous one so the path is not spelled out for you this time.  It should still be easy to find your way around the course but the required turns will be steeper and also harder to coordinate in order to properly line up with the next gate in time.
<p/>
The previous track introduced the basics of manuevering but there are a couple of points that still need to be clarified.
<p/>
In order to alter the heading of the plane appreciably (fine tuning can be achieved with the rudder) you need to bank it in order to use the lift to push the plane to the side.  You can bank the plane by applying aileron pressure but one thing should be stressed.  The ailerons control the bank <b>rate</b> of the plane, not its bank angle.  So in order to achieve a particular bank angle the ailerons have to be deflected only until the angle is reached and then reverted to zero deflection again.  Large deflections will bank the plane faster saving time and space but you'll be more likely to overshoot the angle and trail off your intended path.  There's another complication though.
<p>
It's relatively easy to see if you sketch a turning plane on paper that its wings don't cover the same ground (or air) during the turn.  The inner wing (relative to the arc of the turn) is in fact covering less distance and at the same time the outer wing covers more distance.  This then means that the wings move at different speeds with the inner wing moving slower than the outer wing.  Since the lift produced by a wing depends on its airspeed this has the consequence that the outer wing produces more lift thus tending to bank the plane even more.  One would therefore expect a banked plane to continue banking even without applying any aileron pressure once the bank has been initiated.
<p/>
A quick test will prove this wrong.  In fact, aircraft are designed in such a way as to give them the tendency to cancel out bank and remain level, but only up to a point.  Depending on the steepness of the bank angle the plane might therfore over-bank or level out with varying rates.  You therefore need to actively keep your bank at the desired angle.
<p/>
What this means is that in order to turn one has to apply aileron pressure to initiate the turn by banking the plane to the correct angle and then immediately adjust the ailerons (usually to some small deflection) to compensate for the aircraft's tendency to change its bank angle.  If the turn is shallow positive aileron pressure must be maintained to cancel out the aircraft's lateral stability.  Conversely in the case of a steep enough turn negative aileron pressure may be required to compensate for the plane's tendency to overbank.  One should of course also use the elevators to compensate for the lost lift.
	 ]],
      },

      [5] = {
	 description = "Through the revolvling doors",
	 briefing = [[
This track requires you to pull a 270 degree turn as soon as you complete your first pass through the quadgate in order to traverse it again at right angles.  Of course you can execute this maneuver with a relatively shallow turn but this will result in a large radius and lost time.  What you should go for instead is to bank the plane and start the turn as soon as you exit the gate and go for the tightest turn you can manage.  And this brings us to the subject of stalls.
<p/>
As has been discussed, additional lift can be produced by the wings by pitching the nose of the aircraft up to increase the angle of attack.  Whether you use this lift to climb or to turn is irrelevant but, due to the design of the wings there is a point, that is an angle, past which no additional lift is produced, in fact it is greatly reduced.  The wings are then said to be stalling.
<p/>
Another side effect of high angles of attack is increased drag.  This stands to reason since the wing is more perpendicular to the air stream so that it's resistance is greater but when you get past the stall point the situation deteriorates dramatically because the flow above the wing separates and becomes turbulent (which is why the wing stops producing any lift as well.)
<p/>
The moral of the story is that stalls are to be avoided at all costs.  Not only because they can become dangerous at low speeds, making the aircraft uncontrollable, but because they both slow you down due to the increased drag and reduce your turning or climbing rate as well due to the decreased lift.  Depending on the design of the aircraft you'd normally get various clues that you're about to stall.  Loss of lift is one example and buffeting is another but it's rather unlikely you'll experience any of these from the comfort of your desk chair.  Your aircraft is therefore equipped with a stall warning indicator.  As you approach the critical angle a warning light will start flashing and an audible alarm will sound.  The frequency indicates how close to stalling you are.  Once the sound becomes continuous you've crossed the critical angle and pulling further on the stick will only make things worse.
<p/>
Avoiding stalls is probably the most essential prerequisite for better lap times and in many cases it's what will determine whether you'll make the next pylon or not.
	 ]],
      },
 
      [6] = {
	 description = "U-turns and the chicane",
	 briefing = [[
This track consists of a couple of U-turns with a chicane section in between.  There's nothing much to say about the U-turns.  The first one is relatively tight so you should maneuver it close to the critical angle of attack and try to bank into the turn quickly.  The last turn has a much larger radius so the main thing to watch out for here is estimating the proper turn rate so as not to miss the gate or enter it from the side.
<p/>
Right after the first turn comes the chicane.  This is a set of single pylons forming a line that you have to cross in zig-zag fashion.  It's great for practicing your banking and recovering from turns because you'll have to do both fast.  You shouldn't bank the plane too much but this chicane is large enough that it won't hurt either.  Just try not to wander too much away from the pylons and keep the pressure on the stick smooth and controlled and you should be okay.
	 ]],
      },

      [7] = {
	 description = "Half Cuban Eights",
	 briefing = [[
This track requires yout to perform two succesive Half Cuban Eight maneuvers.  A Half Cuban Eight is useful for turning your plane around while maintaining the same altitude and heading.  It's carried out like this:
<p/>
Turn left to line up with the green gate then pull back on the stick as soon as you pass it.  Climb as fast as possible without stalling the plane.  Keep pulling back until you're inverted, heading towards the red gate.  At this point you should be descending at a 45 degree pitch angle more or less.  Roll the plane and then pull up into level flight as soon as the proper altitude for crossing the red gate is reached.  Make any necessary heading corrections to line up and cross the gate then proceed to cross the blue gate, perform another half cuban to line up with the red gate for a final pass to complete the track.
<p/>
You're going to encounter many Half Cubans in the race tracks so performing them well is important for good lap times.  The key factor, once more, is to pull up as hard as possible without stalling the wings to complete the loop quickly and also keep its radius small but it's also important to take care not to bank the aircraft while performing the maneuver which would lead to losing proper alignment when approaching the next gate.
	 ]],
      }
   },

   racetracks = {
      description = "Race tracks",
      
      [1] = {
   	 description = "Track 1",
   	 briefing = [[
You must perform the following maneuvers to complete the track:

<ul>
  <li> Cross the start gate and make a left turn into the chicane.</li>
  <li> Cross gates 2 and 3 and make a left turn towards gate 4.</li>
  <li> Continue onto gate 5 then make a hard left turn into gate 6.</li>
  <li> Continue turning left into the staring gate then proceed to gate 7. </li>
  <li> Make a half cuban 8 and descend into gate 1 then continue flying the track backwards.</li>
  <li> Right turn past gate 5 and into gate 6. </li>
  <li> Hard left towards gate 5 then proceed to gate 4. </li>
  <li> Left turn into the chicane. </li>
  <li> Cross gates 2 and 3 and turn right towards gate 1. </li>
  <li> Cross gate 1 and complete the track. </li>
</ul>]],
       },
      
      [2] = {
   	 description = "Track 2",
   	 briefing = [[
You must perform the following maneuvers to complete the track:

<ul>
  <li> Cross the start gate and make a right turn into the chicane.</li>
  <li> Cross gates 2 and 3 and make a right turn towards gate 4.</li>
  <li> Continue onto gate 5 then pull up and descend back into gate 4.</li>
  <li> Turn right past gate 7 and into gate 6. </li>
  <li> Hard right into gate 7.</li>
  <li> Proceed to gate 8 then pull up and descend into gate 1. </li>
  <li> Cross gate 1 and the proceed to repeat all steps one more time to complete the track. </li>
</ul>]],
       },
      
      [3] = {
   	 description = "Track 3",
   	 briefing = [[
You must perform the following maneuvers to complete the track:

<ul>
  <li> Cross the start gate and proceed to the chicane.</li>
  <li> Cross gates 2 and 3 and continue towards gate 4.</li>
  <li> Make a hard left turn into gate 5.</li>
  <li> Proceed past gate 7 and into gate 6. </li>
  <li> Hard right into gate 7.</li>
  <li> Proceed to gate 8 then pull up and descend into gate 1. </li>
  <li> Cross gate 1 and the proceed to repeat all steps one more time to complete the track. </li>
</ul>]],
      },
      
      [4] = {
   	 description = "Track 4",
   	 briefing = [[
You must perform the following maneuvers to complete the track:

<ul>
  <li> Fly through the start gate and proceed to the chicane.</li>
  <li> Cross gates 2 and 3 and turn left towards gate 4.</li>
  <li> Proceed turning right into gate 5.</li>
  <li> Make a hard left turn and enter gate 5 again. </li>
  <li> Proceed onto gate 6 then turn right into gate 7.</li>
  <li> Fly through gate 1 then pull and descend into gate 7. </li>
  <li> Repeat all the steps in the opposite direction until you fly through gate 1 to finish the track. </li>
</ul>]],
       },
      
      [5] = {
   	 description = "Track 5",
   	 briefing = [[
You must perform the following maneuvers to complete the track:

<ul>
  <li> Fly through the start gate and make a left turn into gate 2.</li>
  <li> Make a hard left turn and enter gate 2 again, along its other diagonal. </li>
  <li> Proceed, turning slightly to the left into gate 3, then pull up.</li>
  <li> Descend turning slightly right into gate 4. </li>
  <li> Turn left into gate 5, then proceed with a slight right turn into gate 6.</li>
  <li> Pull up then descend into gate 1 and proceed to repeat all steps one more time to complete the track. </li>
</ul>]],
       }
   },
}

-- Load all necessary resources.

for name, trackset in pairs (airrace.tracksets) do
   for i, track in ipairs (trackset) do
      local url, svg

      url = "/" .. name .. "/track" .. i
      svg = "airrace/" .. name .. "/diagram" .. i .. ".lua"

      network.pages[url] = resources.readfile (svg)
      network.mime[url] = "image/svg+xml"
   end
end
