-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- Diagram URL: http://localhost:29176/drawdiagram?track=racetracks/track5.lua&width=750&margin={400,500,400,200}&fontsize=40&scale=6&flipped={true,true,true,false,true,false}&inverted[6]=true&stems[1]={25}&stems[2]={40}&stems[4]={50}&stems[5]={25}&stems[6]={30}

local h, c = 900, 300

aviation.initial = {units.meters {2.2 * c, 0.632103 * c, h}, units.knots (200), 180}

aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {220, 18.5}
aviation.turbidity = 4

-- The race-track setup.

airrace.sequence = {1, 2, 2, 3, 4, 5, 6, 1, 2, 2, 3, 4, 5, 6, 1}
airrace.gates = {
   airrace.gate {
      position = {0.773658 * c, 0.632103 * c, h},
      rotation = 0,
      width = 20,
      color = {1.5, 1.5, 1.3},
   },

   airrace.quadgate {
      position = {-0.777283 * c, 0.017373 * c, h},
      rotation = 34,
      size = {25, 25},
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = {-2.413545 * c, 0.633240 * c, h},
      rotation = 0,
      width = 20,
   },

   airrace.gate {
      position = {-1.647519 * c, -0.448638 * c, h},
      rotation = 105,
      width = 20,
   },

   airrace.gate {
      position = {1.008721 * c, 0.378196 * c, h},
      rotation = 0,
      width = 20,
      color = {1.5, 1.5, 1.6},
   },

   airrace.gate {
      position = {2.628160 * c, -0.038786 * c, h},
      rotation = -37,
      width = 20,
      color = {1.5, 1.5, 0.1},
   },
}
