-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- Diagram URL: http://localhost:29176/drawdiagram?track=racetracks/track3.lua&height=750&margin={150,300,160,200}&fontsize=20&scale=3&stretch[2]=1&stretch[3]=1&inverted={false,true,false,true,true,false,false,false}&flipped={true,true,false,false,false,true,false,true}&stems[1]={50}&stems[2]={20}&stems[3]={10}&stems[5]={30}&stems[7]={30}&stems[8]={30}

local h, c = 500, 45

aviation.initial = {units.meters {c * 0.176, c * 21.742, h},
		    units.knots (180),
		    -90 - 7.319}

aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {142, 18}
aviation.turbidity = 6

-- The race-track setup.

airrace.sequence = {1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1}
airrace.gates = {
   airrace.gate {
      position = {c * -1.761, c * 6.509, h},
      rotation = 90 - 10.819,
      width = 20,
      color = {1.5, 1.5, 1.3},
   },

   airrace.gate {
      position = {c * -3.31, c * -1.26, h},
      rotation = 90 + 64.033,
      width = c * 3.6,
      color = {1.5, 1.5, 1.6},
   },

   airrace.halfgate {
      position = {c * -4.909, c * -4.484, h},
      rotation = 90 + 61.803,
      width = c * 3.6,
      color = {1.5, 1.5, 1.6},
   },

   airrace.gate {
      position = {c * -6.044, c * -10.813, h},
      rotation = 90 + 20.901,
      width = 20,
   },

   airrace.gate {
      position = {c * 1.192, c * -10.813, h},
      rotation = 90,
      width = 20,
   },

   airrace.gate {
      position = {c * 3.163, c * 1.226, h},
      rotation = 90 - 69.534,
      width = 20,
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = {c * 2.318, c * -1.202, h},
      rotation = 90 + 38.3,
      width = 20,
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = {c * 2.449, c * 12.569, h},
      rotation = 90 - 35.373,
      width = 20,
      color = {1.5, 1.5, 0.1},
   },
}
