-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- Diagram URL: http://localhost:29176/drawdiagram?track=racetracks/track1.lua&margin={100,240,130,100}&fontsize=20&scale=3&stretch[2]=1&stretch[3]=1&inverted={true,true,false,true,true,false,true}&flipped={false,false,true,false,false,true,false}&stems[2]={50}&stems[3]={50}&stems[6]={50}

local h, c = 500, 370

aviation.initial = {units.meters {c * 0.20157, c * -1.88826, h},
		    units.knots (180),
		    83.5}

aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {142, 11.5}
aviation.turbidity = 6

-- The race-track setup.

airrace.sequence = {1, 2, 3, 4, 5, 6, 1, 7, 1, 6, 5, 4, 3, 2, 1}
airrace.gates = {
   airrace.gate {
      position = units.meters {c * 0.437058, c * 0.135672, h},
      rotation = 77.354,
      width = 20,
      color = {1.5, 1.5, 1.3},
   },

   airrace.gate {
      position = units.meters {c * 0.014536, c * 1.411474, h},
      rotation = 68.894,
      width = c * 0.54,
      color = {1.5, 1.5, 1.6},
   },

   airrace.halfgate {
      position = units.meters {c * -0.518946, c * 1.563136, h},
      rotation = 80.172,
      width = c * 0.54,
      color = {1.5, 1.5, 1.6},
   },

   airrace.gate {
      position = units.meters {c * -1.215719, c * 0.773331, h},
      rotation = 122.949,
      width = 20,
   },

   airrace.gate {
      position = units.meters {c * -0.240333, c * 0.265530, h},
      rotation = 2.492,
      width = 20,
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = units.meters {c * -0.472429, c * 0.551410, h},
      rotation = 76.336,
      width = 20,
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = units.meters {c * 1.655684, c * 0.704041, h},
      rotation = 15.075,
      width = 20,
      color = {1.5, 1.5, 0.1},
   },
}
