<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Replays</title>
  <link rel="stylesheet" href="stylesheet">
  </link>
</head>

<body>
  <hr/> 

  <div class="logo-container">
    <div class="menu-container">
    <a href="/">back</a>
    </div>
  </div>

  <hr/> 

  <?lua
    local html, replays = "", {}

    -- Delete or rename selected games.

    if query.action then
       if query.action == "delete" then
	  query.action = nil
	  
	  for key in pairs (query) do
	     network.replays.pages[key] = nil
	     network.replays.tags[key] = nil
	  end
       end

       if query.action == "rename" then
	  query.action = nil
	  
	  for key, value in pairs (query) do
	     network.replays.tags[key] = value[2]
	  end
       end	   
    end
 
    -- TODO: fix this when Lua 5.2 arrives.
 
    for uri, tag in getmetatable(network.replays.tags).__pairs() do
       table.insert (replays, {uri, tag})
    end
       
    table.sort (replays, function (a, b) return a[1] > b[1] end)

    html = string.format ([[
  <p>
    %s    
  </p>

  <p>
    <form action="/replays" enctype="multipart/form-data" method="post">
      <input type="hidden" name="importreplay" value="true" />
      You can%s select a replay that has been exported to a file: <input type="file" name="file" /> and <a href="javascript:document.forms[0].submit();">import</a> it.
    </form>
  </p>
    ]], #replays > 0 and "Follow the links in the table below " ..
                         "to replay and manage recorded flights."
                      or "You haven't saved any replays yet.",
        #replays > 0 and " also" or "")

    if #replays >0 then
       html = html .. [[
  <form action="/replays" method="post">
    <input type="hidden" id="action" name="action">
    <table width="100%">
      <col style="width:2em" />
      <tr>
        <th class="striped" colspan="2">Replays</th>
      </tr>]]

       for i, replay in ipairs (replays) do
	  html = html .. string.format([[

      <tr class="%s">
        <td class="striped">
          <input type="checkbox" name="%s" value="true"
	         onchange="updateDescription(this);"/>
        </td>
        <td class="striped" align="left">
          <a href="%s">%s</a>
          <input type="text" name="%s" value="%s" disabled="true"
		 style="width: 100%%; display: none"/>
        </td>
      </tr>
				]], math.mod(i, 2) == 1 and "even" or "odd",
			            replay[1],
				    replay[1], replay[2],
				    replay[1], replay[2])
       end

       html = html .. [[
    </table>
    <a href="javascript:submit(1);">delete</a>
    &middot;
    <a href="javascript:submit(2);">rename</a>
  </form>
       ]]
     end

     return html
    ?>

  <script type="text/javascript">
       function submit(what)
       {
	  if (what == 1) {
	     document.getElementById("action").value = "delete";
          } else {
	     document.getElementById("action").value = "rename";
          }

	  document.forms[1].submit();
       }

       function updateDescription(check)
       {
	  var row = check.parentNode.parentNode;
	  var input = row.getElementsByTagName("input")[1];
	  var link = row.getElementsByTagName("a")[0];

	  if (check.checked) {
	     input.style.display = "inline";
	     input.disabled = false;

	     link.style.display = "none";
	     link.disabled = true;
	  } else {
	     input.style.display = "none";
	     input.disabled = true;

	     link.style.display = "inline";	     
	     link.disabled = false;
	  }
       }
  </script>

  <?lua
    local redirect = [[
<head></head>
<body onload="window.location = '/fly';"></body>
       ]]

    if query.importreplay and #query.file[1] > 0 then
       assert(loadstring(query.file[3]))()
       
       return redirect
    end
   ?>
  <hr> 
</body>
