<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<?lua
   if not airrace.running then
      airrace.saved = query.saved == "true"
      airrace.headline = query.headline or
	                 string.format("%s at %s/%s on %s",
				       os.getenv("USER"),
				       query.trackset, query.track,
				       os.date ("%a %b %d, %R %Y"))

      airrace.track = string.format("%s/track%s.lua",
				    query.trackset, query.track)

      resources.dofile "airrace/restart.lua"

      if query.script then
	 aviation.nodes.plane.avionics.script =
	    assert(loadstring("return " .. query.script))()
      end

      graphics.hide = false
      network.block = false
   end
 ?>

<head>
  <title><?lua return airrace.headline ?></title>
  <style type="text/css">
  table {
      width:100%;
      height:100%;
  }

  div.framed {
      background-color: slategrey;
      border-style:dotted;
      border-width:thin;
      border-color:black;
      text-align:center;
  }
  </style>
</head>

<body onload="javascript:window.blur();">
  <table>
     <tr><td>
	 <div class="framed">
	   <h1> <span id="state"><?lua return airrace.headline ?></h1>
	 </div>
     </td></tr>
  </table>

  <script type="text/javascript">
    var request, timer

    request = new XMLHttpRequest();

    function check()
    {
       if (request.readyState == 4) {
	  window.location = "/debriefing";
       }
    }

    request.open("GET", "/finished", true);
    request.onreadystatechange = check;
    request.send(null);
  </script>
</body>

