-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local h, c = 900, 100

aviation.initial = {units.meters {-300, 0, h}, units.knots (180), 0}

aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {142, 15.5}
aviation.turbidity = 3

-- The race-track setup.

airrace.sequence = {1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 1}
airrace.gates = {
   airrace.gate {
      position = {0, 0, h},
      width = 20,
   },

   airrace.quadgate {
      position = {5 * c, 0, h},
      size = {25, 25},
      color = {1.5, 1.5, 1.6},
   },

   airrace.quadgate {
      position = {5 * c, 5 * c, h},
      size = {25, 25},
      color = {1.5, 1.5, 1.6},
   },

   airrace.gate {
      position = {0, 5 * c, h},
      width = 20,
   },

   airrace.quadgate {
      position = {-5 * c, 5 * c, h},
      size = {25, 25},
      color = {1.5, 1.5, 1.6},
   },

   airrace.quadgate {
      position = {-5 * c, 0, h},
      size = {25, 25},
      color = {1.5, 1.5, 1.6},
   },
}
