/*
 *   This file is part of Auralquiz
 *   Copyright 2011-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include <QApplication>
#include <QTranslator>
#include <QtDebug>
#include <iostream>

#include "auralwindow.h"


#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
void customMessageHandlerQt4(QtMsgType type, const char *msg)
{
    // do nothing
    Q_UNUSED(type)
    Q_UNUSED(msg)

    return;
}
#else
void customMessageHandlerQt5(QtMsgType type,
                             const QMessageLogContext &context,
                             const QString &msg)
{
    Q_UNUSED(type)
    Q_UNUSED(context)
    Q_UNUSED(msg)

    // Do nothing

    return;
}
#endif

int main(int argc, char *argv[])
{
    QApplication auralApp(argc, argv);

    auralApp.setApplicationName("Auralquiz");
    auralApp.setApplicationVersion("0.9.0-beta");
    auralApp.setOrganizationName("JanCoding");
    auralApp.setOrganizationDomain("jancoding.wordpress.com");

    std::cout << QString("Auralquiz v%1 - JanKusanagi 2011-2016\n")
                 .arg(auralApp.applicationVersion()).toStdString();
    std::cout << QString("- Built with Qt v%1\n")
                 .arg(QT_VERSION_STR).toStdString();
    std::cout << QString("- Running with Qt v%1\n\n")
                 .arg(qVersion()).toStdString();
    std::cout.flush();


    // Register custom message handler, to hide debug messages unless specified
    if (qApp->arguments().contains("--debug", Qt::CaseInsensitive))
    {
        std::cout << "Debug messages enabled\n";
    }
    else
    {
        std::cout << "To see debug messages while running, use --debug\n";
#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
        qInstallMsgHandler(customMessageHandlerQt4);
#else
        qInstallMessageHandler(customMessageHandlerQt5);
#endif

    }


    // Enable localization
    QTranslator translator;
    QString languageFile;
    // get LANG environment variable, and generate the resource filename
    languageFile = QString(":/translations/auralquiz_%1")
                   .arg(qgetenv("LANG").constData());
    std::cout << "Using translation file: "
              << languageFile.toStdString() << "\n";

    translator.load(languageFile);
    auralApp.installTranslator(&translator);

    std::cout.flush();


    AuralWindow auralWindow;
    auralWindow.show();

    return auralApp.exec();
}
