#
# Copyright (C) by Stefano Falsetto
# e-mail contact ....: mailto:stefko5@inwind.it
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Shared functions for MP3-related config plugins
#


shared_mp3_desc () {
  echo
  begin_check $"MP3 description string in $MAGICFILE"
  MPEGS1_1=0
  # Description
  local L1=$($EGREP "^0[[:space:]].*beshort[[:space:]].*\&0xffe0" $MAGICFILE| \
       tr -s '\t' ' '|cut -d' ' -f4)
  if [ -z "$L1" ]; then
    local L1=$($EGREP "^0[[:space:]].*beshort[[:space:]].*\&0xfff0" $MAGICFILE|\
               tr -s '\t' ' '|cut -d' ' -f4)
  fi
  # Version
  local L2=$($EGREP "^>1[[:space:]].*byte&0x08[[:space:]].*=0x08" $MAGICFILE| \
             tr -s '\t' ' '|cut -d' ' -f4-|cut -b3-)
  # Layer
  local L3_1=$($EGREP "^>>1[[:space:]].*byte[[:space:]].*&0x02" $MAGICFILE| \
               tr -s '\t' ' '|cut -d' ' -f4-|cut -b3-|head -n 1)
  local L3_2=$($EGREP "^>>1[[:space:]].*byte[[:space:]].*&0x04" $MAGICFILE| \
               tr -s '\t' ' '|cut -d' ' -f4-|cut -b3-|head -n 1)
  LONGD="${L1}${L2}${L3_1}"
  MPEGS2_1=${#LONGD}
  if [ $MPEGS2_1 -eq 0 ]; then
    force_trust "mpeg criteria layer 3"
  fi
  LONGD_2="${L1}${L2}${L3_2}"
  MPEGS1_2=0
  MPEGS2_2=${#LONGD_2}
  if [ $MPEGS2_2 -eq 0 ]; then
    force_trust "mpeg criteria layer 2"
  fi
  MPEGCRITERIA=$LONGD
  MPEGCRITERIA_2=$LONGD_2
}

shared_summary_strings () {
  echo
  lechoc CYAN $"Summary of command used by $1:"
  lechoc CYAN $"Extract time:"
  lechoc YELLOW " -> $1 $EXTRACT_TIME song.mp3"
  lechoc CYAN $"Buffered decode:"
  lechoc YELLOW " -> $1 $BUFFERED_DECODE song.mp3 | ..."
  lechoc CYAN $"Decoding to stdout:"
  lechoc YELLOW " -> $1 $DECODE_TO_STDOUT song.mp3 | ..."
  lechoc CYAN $"Normal decoding to wav (default):"
  lechoc YELLOW " -> $1 $NORMALDECODE $TO_wav file.wav song.mp3"
  lechoc CYAN $"Normal decoding to cdr:"
  lechoc YELLOW " -> $1 $NORMALDECODE $TO_cdr file.cdr song.mp3"
  lechoc CYAN $"Normal decoding to au:"
  lechoc YELLOW " -> $1 $NORMALDECODE $TO_au file.au song.mp3"
  lechoc CYAN $"MP3 layer 3 criteria:"
  lechoc YELLOW $" -> %s" "$MPEGCRITERIA"
  lechoc CYAN $"MP3 layer 2 criteria"
  lechoc YELLOW $" -> %s" "$MPEGCRITERIA_2"
  echo
}

