#!/bin/bash

BASEDIR=/usr/local
BINDIR=$BASEDIR/bin
SHAREDIR="$BASEDIR/share/MP3do"
PLUGINDIR=$SHAREDIR/plugins
MAINPROGS="MP3do ConfigMP3do"
PROGRAMS="$MAINPROGS MP3do-no-po echoc lechoc"
MODE="0755"
OWN="root"
GRP="root"

# Find LOCALEDIR
DIRSLOCALE="/usr/share/locale /usr/lib/nls/loc /usr/lib/locale /usr/lib/nls"
for i in $DIRSLOCALE; do
  if [ -d $i/$LANG/LC_MESSAGES ]; then
    echo "Found locale dir in $i";
    LOCALEDIR=$i;
  fi
done

# Uninstall
if [ "$1" = "-u" ] || [ "$1" = "--uninstall" ]; then
  echo "Removing all programs..."
  if [ "$(whoami)" != "root" ]; then
    echo "You're not root!"
    echo "You can remove ONLY files in your $HOME/MP3do dir."
    echo -n "Press ENTER to continue or CTRL+C to exit "
    read
    BASEDIR=$HOME
    BINDIR=$BASEDIR/MP3do
    LOCALEDIR=""
    PLUGINDIR="$BINDIR/plugins"
  fi
  for prg in $PROGRAMS; do
    rm -fv $BINDIR/$prg
  done

  echo -n "Removing all plugins dir..."
  rm -Rfv $PLUGINDIR
  echo -n "Removing MP3do dir if void..."
  rmdir $PLUGINDIR 2>/dev/null
  if [ $? -eq 1 ]; then
    echo "WARNING: $PLUGINDIR is not empty: there are some other files!"
  fi

  [ -z $LOCALEDIR ] && rmdir $BINDIR 
  
  if [ ! -z "$LOCALEDIR" ]; then
    L=$(cat po/LANGUAGES)
    for prg in $MAINPROGS; do
      echo -n "Removing locale for $prg..."
      for i in $L; do
        rm -f $LOCALEDIR/$i/LC_MESSAGES/$prg.mo
      done
      echo "Done"
    done
  fi
  echo
  echo "Uninstall finished."
  echo
  exit
fi

# Install
if [ "$(whoami)" != "root" ]; then
  echo "You're not root!"
  echo "You can continue installing this software in $HOME/MP3do dir."
  echo "Localization will not be used. Messages will be all in English."  
  echo "ConfigMP3do and MP3do can only be run in $HOME/MP3do dir."
  echo -n "Press ENTER to continue or CTRL+C to exit "
  read
  BASEDIR=$HOME
  BINDIR=$BASEDIR/MP3do
  LOCALEDIR=""
  OWN="$(whoami)"
  GRP="$(groups|cut -d' ' -f1)"
  PLUGINDIR="$BINDIR/plugins"
fi

echo "Updating and installing programs..."
mkdir -p $BINDIR
for prg in $PROGRAMS; do
  if [ -e "$prg.in" ]; then
    echo -n "Making $prg from ${prg}.in ..."
    if [ -z "$LOCALEDIR" ]; then
      cat "$prg.in"|sed -e '/^TEXTDOMAINDIR.*/,/^fi/d'>$prg
    else
      PLOCDIR=${LOCALEDIR//\//\\/}
      cat "$prg.in"| \
       sed -e "s/TEXTDOMAINDIR=\@TEXTDOMAINDIR\@/TEXTDOMAINDIR=$PLOCDIR/"\
           -e '/^if.*\[.*\$TEXTDOMAINDIR.*/,/^fi/d' >$prg
    fi
    echo "Done"
  fi
  echo -n "Installing $prg..."
  install -m $MODE -o $OWN -g $GRP $prg $BINDIR
  echo "Done"
done

echo "Installing plugins..."
mkdir -p $PLUGINDIR
echo -n "  Creating tree dir..."
find plugins -type d|while read i; do
  ADD=${i:8}
  mkdir -p $PLUGINDIR/$ADD
done
echo "done"
echo -n "  Installing files..."
find plugins -type f|while read i; do
  ADD=${i:8}
  install -m 444 -o $OWN -g $GRP $i $PLUGINDIR/$ADD
done
echo "done"
echo "done"

if [ ! -z "$LOCALEDIR" ]; then
  L=$(cat po/LANGUAGES)
  echo "Installing locales $L..."

  for prg in $MAINPROGS; do
    echo -n "Installing locale for $prg..."
    for i in $L; do
      mkdir -p $LOCALEDIR/$i/LC_MESSAGES
      cp -f po/generated/$prg.$i.mo $LOCALEDIR/$i/LC_MESSAGES/$prg.mo
    done
    echo "Done"
  done
fi

echo "Installing MP3do magic file..."
install -m 444 -o $OWN -g $GRP magic-MP3do $SHAREDIR/magic
echo "Done"

cat <<EOF

MP3do successfull installed!
Now you can cd to $BINDIR and configure MP3do with ConfigMP3do 
or making you own mp3do.rc file.
Try 'ConfigMP3do --help' to have more informations about configuration options.

>>> If you're upgrading from a prior version of this software, 
>>> please re-run ConfigMP3do.
>>> If you've some trouble running in phases 1 or 2 running MP3do you
>>> can try to re-run ConfigMP3do adding following parameter:
>>> --magic-dir $SHAREDIR

If this set of scripts don't works for you please send me an e-mail at:
stefko5@inwind.it

EOF

