//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include <gtkmm.h>
#include "main.h"

#include "progress-dialog.h"

ProgressDialog::ProgressDialog()
{
    Glib::RefPtr<Gtk::Builder> xml
	= Gtk::Builder::create_from_file(Main::get_glade_path()
				    + "/progress-dialog.gtk");

    xml->get_widget("dialog", dialog);
    dialog->set_icon_from_file(Main::get_data_path() + "/tapioca.png");

    xml->get_widget("progressbar", progressbar);
    xml->get_widget("label", label);
    
    dialog->signal_response().connect
      (sigc::mem_fun(*this, &ProgressDialog::on_dialog_closed));
}

void ProgressDialog::on_dialog_closed(int response)
{
  disconnect();
  aborted.emit();
}

ProgressDialog::~ProgressDialog()
{
  //if (dialog)
    //{
      //delete dialog;
      //dialog = NULL;
    //}
}
void ProgressDialog::set_parent_window(Gtk::Window &parent)
{
    dialog->set_transient_for(parent);
    //dialog->set_position(Gtk::WIN_POS_CENTER_ON_PARENT);
}

void ProgressDialog::disconnect()
{
  for (std::list<sigc::connection>::iterator it = connections.begin();
       it != connections.end(); it++)
    (*it).disconnect();
}
void ProgressDialog::hide()
{
  dialog->hide();
  disconnect();
}

void ProgressDialog::run()
{
  dialog->run();
}
